/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.routes;

import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.routes.FWDCallEvent;
import dexlogic.parsec.routes.FlowManager;
import dexlogic.parsec.routes.LocalObjectAgent;
import dexlogic.parsec.routes.ProxyStateHandler;
import dexlogic.parsec.routes.RPCInvokeAdapter;
import dexlogic.parsec.routes.RPCInvokeHandler;
import dexlogic.parsec.routes.RemoteObjectProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class FlowProxy {
    private FlowManager flowManager;
    private String xmlString;
    private ArrayList<ObjectGateway> objectGatewayList = new ArrayList();
    private HashMap<RPCInvokeAdapter, RPCInvokeHandler[]> rpcHandlerMap = new HashMap();
    private ArrayList<ProxyStateHandler> stateHandlerList = new ArrayList();
    long graphHandle = 0L;

    private void fwdCallHandler(int n, FWDCallEvent fWDCallEvent) throws ParsecException {
        if (this.flowManager.hasEntity()) {
            this.flowManager.remotePost(n, fWDCallEvent.getRPCArg());
        }
    }

    private void addRPCInvokeAdapter(int n, RPCInvokeAdapter rPCInvokeAdapter) {
        if (rPCInvokeAdapter.selector == null || !(rPCInvokeAdapter.selector instanceof String || rPCInvokeAdapter.selector instanceof Integer)) {
            throw new IllegalArgumentException("Selector must be a String or Integer object");
        }
        RPCInvokeHandler rPCInvokeHandler = this.flowManager.createRPCInvokeHandler(n, rPCInvokeAdapter);
        this.addInvokeHandler(rPCInvokeAdapter, rPCInvokeHandler);
        this.flowManager.addDispatchHandler(rPCInvokeHandler);
        if (rPCInvokeAdapter.selector instanceof String) {
            // empty if block
        }
    }

    private void removeRPCInvokeAdapter(int n, RPCInvokeAdapter rPCInvokeAdapter) {
        RPCInvokeHandler rPCInvokeHandler = this.removeInvokeHandler(rPCInvokeAdapter);
        if (rPCInvokeHandler == null) {
            throw new IllegalArgumentException("RPC invoke adapter not found");
        }
        this.flowManager.removeDispatchHandler(rPCInvokeHandler);
        if (rPCInvokeAdapter.selector instanceof String) {
            // empty if block
        }
    }

    FlowProxy(FlowManager flowManager) {
        this.flowManager = flowManager;
    }

    void addObjectGateway(int n, LocalObjectAgent localObjectAgent) {
        this.objectGatewayList.add(new ObjectGateway(n, localObjectAgent));
    }

    Iterator<ObjectGateway> getObjectGatewayIterator() {
        return this.objectGatewayList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInvokeHandler(RPCInvokeAdapter rPCInvokeAdapter, RPCInvokeHandler rPCInvokeHandler) {
        HashMap<RPCInvokeAdapter, RPCInvokeHandler[]> hashMap = this.rpcHandlerMap;
        synchronized (hashMap) {
            RPCInvokeHandler[] rPCInvokeHandlerArray = this.rpcHandlerMap.get(rPCInvokeAdapter);
            rPCInvokeHandlerArray = ParsecTools.arrayAdd(RPCInvokeHandler.class, rPCInvokeHandlerArray, rPCInvokeHandler);
            this.rpcHandlerMap.put(rPCInvokeAdapter, rPCInvokeHandlerArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RPCInvokeHandler removeInvokeHandler(RPCInvokeAdapter rPCInvokeAdapter) {
        RPCInvokeHandler rPCInvokeHandler = null;
        HashMap<RPCInvokeAdapter, RPCInvokeHandler[]> hashMap = this.rpcHandlerMap;
        synchronized (hashMap) {
            RPCInvokeHandler[] rPCInvokeHandlerArray = this.rpcHandlerMap.get(rPCInvokeAdapter);
            if (rPCInvokeHandlerArray == null) {
                return null;
            }
            rPCInvokeHandler = rPCInvokeHandlerArray[0];
            if ((rPCInvokeHandlerArray = ParsecTools.arrayRemoveFirst(rPCInvokeHandlerArray)) == null) {
                this.rpcHandlerMap.remove(rPCInvokeAdapter);
            } else {
                this.rpcHandlerMap.put(rPCInvokeAdapter, rPCInvokeHandlerArray);
            }
        }
        return rPCInvokeHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<RPCInvokeHandler> getInvokeHandlerIterator() {
        ArrayList<RPCInvokeHandler> arrayList = new ArrayList<RPCInvokeHandler>();
        HashMap<RPCInvokeAdapter, RPCInvokeHandler[]> hashMap = this.rpcHandlerMap;
        synchronized (hashMap) {
            for (RPCInvokeHandler[] rPCInvokeHandlerArray : this.rpcHandlerMap.values()) {
                for (int i = 0; i < rPCInvokeHandlerArray.length; ++i) {
                    arrayList.add(rPCInvokeHandlerArray[i]);
                }
            }
        }
        return arrayList.iterator();
    }

    void addStateHandler(ProxyStateHandler proxyStateHandler) {
        this.stateHandlerList.add(proxyStateHandler);
    }

    void removeStateHandler(ProxyStateHandler proxyStateHandler) {
        this.stateHandlerList.remove(proxyStateHandler);
    }

    Iterator<ProxyStateHandler> getStateHandlerIterator() {
        return this.stateHandlerList.iterator();
    }

    void setXML(String string) {
        this.xmlString = string;
    }

    String getXML() {
        return this.xmlString;
    }

    class ObjectGateway
    implements RemoteObjectProxy {
        int objID;
        LocalObjectAgent objectAgent;

        ObjectGateway(int n, LocalObjectAgent localObjectAgent) {
            this.objID = n;
            this.objectAgent = localObjectAgent;
        }

        void attach() {
            this.objectAgent.addRemoteObjectProxy(this);
        }

        void detach() {
            this.objectAgent.removeRemoteObjectProxy(this);
        }

        @Override
        public void fwdCallHandler(FWDCallEvent fWDCallEvent) throws ParsecException {
            FlowProxy.this.fwdCallHandler(this.objID, fWDCallEvent);
        }

        @Override
        public void addRPCInvokeAdapter(RPCInvokeAdapter rPCInvokeAdapter) {
            FlowProxy.this.addRPCInvokeAdapter(this.objID, rPCInvokeAdapter);
        }

        @Override
        public void removeRPCInvokeAdapter(RPCInvokeAdapter rPCInvokeAdapter) {
            FlowProxy.this.removeRPCInvokeAdapter(this.objID, rPCInvokeAdapter);
        }
    }
}

