/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.routes;

import dexlogic.parsec.InternalParsecException;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.routes.FlowProxyBuilder;
import dexlogic.parsec.routes.FlowProxyEditor;
import dexlogic.parsec.routes.LocalObjectAgent;
import dexlogic.parsec.routes.MediaSource;
import java.io.File;
import java.net.URI;

public class MediaProxyBuilder
implements FlowProxyBuilder {
    private MediaSource mediaSource;

    private String buildGenericAttributes(FlowProxyEditor flowProxyEditor, String string, MediaSource.Element element) {
        int n;
        Object object = "";
        String string2 = "";
        LocalObjectAgent localObjectAgent = element.getObjectAgent();
        int n2 = n = localObjectAgent == null ? 0 : flowProxyEditor.getNextObjectNum();
        if (n > 0) {
            object = " objID='" + n + "'";
            string2 = flowProxyEditor.addObjectAgent(n, localObjectAgent);
        }
        string = ParsecTools.concatSetupParam(string, element.getSetupArgs());
        Object object2 = (string = ParsecTools.concatSetupParam(string, string2)) == null ? "" : " setup=' " + string + " '";
        String string3 = ParsecTools.trimString(element.getRPCArg());
        Object object3 = string3 == null ? "" : " rpc='" + string3 + "'";
        return (String)object + (String)object2 + (String)object3;
    }

    private String buildPlugin(FlowProxyEditor flowProxyEditor, int n, MediaSource.Plugin plugin, StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = new StringBuilder();
        int n2 = flowProxyEditor.getNextPluginServiceNum();
        String string = "P" + n2;
        String string2 = " driverID='" + plugin.driverID + "'";
        String string3 = " style='" + plugin.scheme + "'";
        String string4 = " name='F" + n2 + "'";
        String string5 = this.buildGenericAttributes(flowProxyEditor, null, plugin);
        stringBuilder2.append("  <filterDriver" + string2 + string3 + string4 + string5 + ">\n");
        String string6 = " style='" + ParsecTools.getServiceTypeText(n) + "'";
        String string7 = " name='" + string + "'";
        Object object = "";
        String string8 = this.buildPatchList(flowProxyEditor, n, plugin.routing, stringBuilder);
        if (string8 != null) {
            object = " patch='" + string8 + "'";
        }
        stringBuilder2.append("    <service" + string6 + string7 + (String)object + " />\n");
        stringBuilder2.append("  </filterDriver>");
        if (stringBuilder.length() != 0) {
            stringBuilder.insert(0, "\n\n");
        }
        stringBuilder.insert(0, stringBuilder2.toString());
        return string;
    }

    private String buildPatchList(FlowProxyEditor flowProxyEditor, int n, MediaSource.Routing routing, StringBuilder stringBuilder) {
        String string = null;
        if (routing.plugins.size() != 0) {
            StringBuilder stringBuilder2 = new StringBuilder();
            for (MediaSource.Plugin plugin : routing.plugins) {
                if (!plugin.routing.enabled) continue;
                if (stringBuilder2.length() != 0) {
                    stringBuilder2.append(", ");
                }
                if (plugin.scheme != null && plugin.scheme.length() != 0) {
                    stringBuilder2.append(this.buildPlugin(flowProxyEditor, n, plugin, stringBuilder));
                    continue;
                }
                String string2 = this.buildPatchList(flowProxyEditor, n, plugin.routing, stringBuilder);
                if (string2 == null) continue;
                stringBuilder2.append(string2);
            }
            string = stringBuilder2.toString();
        } else if (routing.patch != null) {
            string = routing.patch;
        }
        return string;
    }

    public MediaProxyBuilder(MediaSource mediaSource) {
        this.mediaSource = mediaSource;
    }

    @Override
    public void buildFlowProxy(FlowProxyEditor flowProxyEditor) throws ParsecException {
        Object object;
        String string;
        Object object2;
        String string2;
        Object object3;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (MediaSource.Trunk object42 : this.mediaSource.getFeed().trunks) {
            if (!object42.enabled) continue;
            object3 = "";
            if (object42.trunkName != null && (string2 = object42.trunkName.trim()).length() != 0) {
                object3 = " name='" + string2 + "'";
            }
            object2 = "";
            string = object42.getSetupArgs();
            if (string != null && (string = string.trim()).length() != 0) {
                object2 = " setup=' " + string + " '";
            }
            stringBuilder2.append("      <trunk" + (String)object3 + (String)object2 + ">\n");
            for (MediaSource.Jack jack : object42.jacks) {
                String string3;
                if (!jack.routing.enabled) continue;
                Object object4 = "";
                if (jack.jackName != null && (string3 = jack.jackName.trim()).length() != 0) {
                    object4 = " name='" + string3 + "'";
                }
                Object object5 = "";
                String string4 = this.buildPatchList(flowProxyEditor, jack.serviceType, jack.routing, stringBuilder);
                if (string4 != null) {
                    object5 = " patch='" + string4 + "'";
                }
                Object object6 = "";
                String string5 = jack.getSetupArgs();
                if (string5 != null && (string5 = string5.trim()).length() != 0) {
                    object6 = " setup=' " + string5 + " '";
                }
                stringBuilder2.append("        <jack" + (String)object4 + (String)object5 + (String)object6 + " />\n");
            }
            stringBuilder2.append("      </trunk>\n");
        }
        URI uRI = this.mediaSource.getFeed().absoluteURI;
        string2 = uRI.getScheme();
        if (string2 == null || string2.equals("file")) {
            object3 = new File(uRI);
            object2 = "path:\"" + ((File)object3).getPath() + "\"";
            string = this.buildGenericAttributes(flowProxyEditor, (String)object2, this.mediaSource.getFeed());
            object = "  <sourceDriver driverID='FileReader'>\n    <feed style='" + this.mediaSource.getFeed().scheme + "' name='#1' " + string + ">\n";
        } else if (string2.equals("imsp")) {
            object = "  <sourceDriver driverID='IDNServer'>\n    <feed style='" + this.mediaSource.getFeed().scheme + "' name='#1' setup='pullAddress:\"" + uRI.getAuthority() + "\"'>\n";
        } else {
            throw new InternalParsecException("Invalid URI scheme" + string2);
        }
        object3 = "    </feed>\n  </sourceDriver>\n";
        stringBuilder2.insert(0, (String)object);
        stringBuilder2.append((String)object3);
        if (stringBuilder.length() != 0) {
            stringBuilder2.insert(0, "\n\n");
            stringBuilder2.insert(0, stringBuilder.toString());
        }
        stringBuilder2.insert(0, "<dxcSetup>\n");
        stringBuilder2.append("</dxcSetup>");
        flowProxyEditor.setXML(stringBuilder2.toString());
    }
}

