/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.routes;

import dexlogic.parsec.routes.RPCArgException;
import dexlogic.parsec.routes.RPCArray;
import dexlogic.parsec.routes.RPCBatch;
import dexlogic.parsec.routes.RPCJob;
import dexlogic.parsec.routes.RPCNumber;
import dexlogic.parsec.routes.RPCObject;
import java.util.Iterator;
import java.util.Map;

public class RPCArg {
    private RPCArg() {
    }

    private static RPCNumber readJSONNumber(CharStream charStream) throws RPCArgException {
        char c;
        int n = charStream.getPos();
        if (charStream.peekChar() == '-') {
            charStream.skipChar();
        }
        if ((c = charStream.peekChar()) == '0') {
            charStream.skipChar();
        } else if (c >= '1' && c <= '9') {
            charStream.expectDigitsAndSkip();
        } else {
            throw new RPCArgException(charStream, "Not a digit: '" + c + "'");
        }
        if (charStream.hasChars() && charStream.peekChar() == '.') {
            charStream.skipChar();
            charStream.expectDigitsAndSkip();
        }
        if (charStream.hasChars() && (charStream.peekChar() == 'E' || charStream.peekChar() == 'e')) {
            charStream.skipChar();
            c = charStream.peekChar();
            if (c == '-' || c == '+') {
                charStream.skipChar();
            }
            charStream.expectDigitsAndSkip();
        }
        int n2 = charStream.getPos();
        return new RPCNumber(charStream.substring(n, n2));
    }

    private static String readJSONString(CharStream charStream) throws RPCArgException {
        int n;
        charStream.expectCharAndSkip(Character.valueOf('\"'));
        int n2 = charStream.getPos();
        while ((n = charStream.peekChar()) != 34) {
            if (n == 92) {
                charStream.skipChar();
                n = charStream.peekChar();
                if (n == 34 || n == 92 || n == 47 || n == 98 || n == 102 || n == 110 || n == 114 || n == 116) {
                    charStream.skipChar();
                    continue;
                }
                if (n == 117) {
                    charStream.skipChar();
                    charStream.expectHexCharAndSkip();
                    charStream.expectHexCharAndSkip();
                    charStream.expectHexCharAndSkip();
                    charStream.expectHexCharAndSkip();
                    continue;
                }
                throw new RPCArgException(charStream, "Expected escaped character");
            }
            if (n >= 32) {
                charStream.skipChar();
                continue;
            }
            throw new RPCArgException(charStream, "Invalid JSON string character");
        }
        n = charStream.getPos();
        charStream.expectCharAndSkip(Character.valueOf('\"'));
        return charStream.substring(n2, n);
    }

    private static Object readJSONValue(CharStream charStream) throws RPCArgException {
        Object object = null;
        char c = charStream.peekChar();
        if (c == 'n') {
            charStream.skipChar();
            charStream.expectCharAndSkip(Character.valueOf('u'));
            charStream.expectCharAndSkip(Character.valueOf('l'));
            charStream.expectCharAndSkip(Character.valueOf('l'));
        } else if (c == '-' || c >= '0' && c <= '9') {
            object = RPCArg.readJSONNumber(charStream);
        } else if (c == '\"') {
            object = RPCArg.readJSONString(charStream);
        } else if (c == '{') {
            object = RPCArg.readJSONObject(charStream);
        } else if (c == '[') {
            object = RPCArg.readJSONArray(charStream);
        } else if (c == 't') {
            charStream.skipChar();
            charStream.expectCharAndSkip(Character.valueOf('r'));
            charStream.expectCharAndSkip(Character.valueOf('u'));
            charStream.expectCharAndSkip(Character.valueOf('e'));
            object = true;
        } else if (c == 'f') {
            charStream.skipChar();
            charStream.expectCharAndSkip(Character.valueOf('a'));
            charStream.expectCharAndSkip(Character.valueOf('l'));
            charStream.expectCharAndSkip(Character.valueOf('s'));
            charStream.expectCharAndSkip(Character.valueOf('e'));
            object = false;
        } else {
            throw new RPCArgException(charStream, "Invalid JSON value");
        }
        return object;
    }

    private static RPCObject readJSONObject(CharStream charStream) throws RPCArgException {
        RPCObject rPCObject = new RPCObject();
        charStream.expectCharAndSkip(Character.valueOf('{'));
        charStream.skipWhitespace();
        if (charStream.peekChar() == '}') {
            charStream.skipChar();
            return rPCObject;
        }
        while (true) {
            String string = RPCArg.readJSONString(charStream);
            charStream.skipWhitespace();
            charStream.expectCharAndSkip(Character.valueOf(':'));
            charStream.skipWhitespace();
            Object object = RPCArg.readJSONValue(charStream);
            rPCObject.put(string, object);
            charStream.skipWhitespace();
            if (charStream.peekChar() == '}') break;
            charStream.expectCharAndSkip(Character.valueOf(','));
            charStream.skipWhitespace();
        }
        charStream.skipChar();
        return rPCObject;
    }

    private static RPCArray readJSONArray(CharStream charStream) throws RPCArgException {
        RPCArray rPCArray = new RPCArray();
        charStream.expectCharAndSkip(Character.valueOf('['));
        charStream.skipWhitespace();
        if (charStream.peekChar() == ']') {
            charStream.skipChar();
            return rPCArray;
        }
        while (true) {
            rPCArray.add(RPCArg.readJSONValue(charStream));
            charStream.skipWhitespace();
            if (charStream.peekChar() == ']') break;
            charStream.expectCharAndSkip(Character.valueOf(','));
            charStream.skipWhitespace();
        }
        charStream.skipChar();
        return rPCArray;
    }

    private static void writeJSONValue(StringBuilder stringBuilder, Object object) {
        if (object == null) {
            stringBuilder.append("null");
        } else if (object instanceof RPCNumber) {
            stringBuilder.append(((RPCNumber)object).toString());
        } else if (object instanceof String) {
            stringBuilder.append('\"').append((String)object).append('\"');
        } else if (object instanceof RPCObject) {
            RPCArg.writeJSONObject(stringBuilder, null, (RPCObject)object);
        } else if (object instanceof RPCArray) {
            RPCArg.writeJSONArray(stringBuilder, null, (RPCArray)object);
        } else if (object instanceof Boolean) {
            String string = (Boolean)object != false ? "true" : "false";
            stringBuilder.append(string);
        } else {
            throw new IllegalArgumentException("Invalid object type: " + object.getClass());
        }
    }

    static void writeJSONObject(StringBuilder stringBuilder, String string, RPCObject rPCObject) {
        if (string == null) {
            stringBuilder.append("{ ");
        } else {
            stringBuilder.append(string).append("{\n");
        }
        Iterator iterator = rPCObject.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (string != null) {
                stringBuilder.append(string).append("  ");
            }
            stringBuilder.append("\"").append((String)entry.getKey()).append('\"').append(": ");
            RPCArg.writeJSONValue(stringBuilder, entry.getValue());
            if (iterator.hasNext()) {
                stringBuilder.append(',');
            }
            if (string == null) {
                stringBuilder.append(" ");
                continue;
            }
            stringBuilder.append("\n");
        }
        if (string == null) {
            stringBuilder.append("}");
        } else {
            stringBuilder.append(string).append("}\n");
        }
    }

    static void writeJSONArray(StringBuilder stringBuilder, String string, RPCArray rPCArray) {
        if (string == null) {
            stringBuilder.append("[ ");
        } else {
            stringBuilder.append(string).append("[\n");
        }
        Iterator iterator = rPCArray.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (string != null) {
                stringBuilder.append(string).append("  ");
            }
            RPCArg.writeJSONValue(stringBuilder, e);
            if (iterator.hasNext()) {
                stringBuilder.append(',');
            }
            if (string == null) {
                stringBuilder.append(" ");
                continue;
            }
            stringBuilder.append("\n");
        }
        if (string == null) {
            stringBuilder.append("]");
        } else {
            stringBuilder.append(string).append("]\n");
        }
    }

    public static Object parseJSON(String string) throws RPCArgException {
        Cloneable cloneable = null;
        string = string.strip();
        CharStream charStream = new CharStream(string);
        if (string.startsWith("{") && string.endsWith("}")) {
            cloneable = RPCArg.readJSONObject(charStream);
        } else if (string.startsWith("[") && string.endsWith("]")) {
            cloneable = RPCArg.readJSONArray(charStream);
        } else {
            throw new RPCArgException(charStream, "No valid top-level JSON");
        }
        if (charStream.hasChars()) {
            throw new RPCArgException(charStream, "Excess argument characters");
        }
        return cloneable;
    }

    public static RPCBatch parse(String string) throws RPCArgException {
        if (string == null) {
            return null;
        }
        if ((string = string.strip()).length() == 0) {
            return null;
        }
        RPCBatch rPCBatch = null;
        CharStream charStream = new CharStream(string);
        if (string.startsWith("{") && string.endsWith("}")) {
            RPCObject rPCObject = RPCArg.readJSONObject(charStream);
            if (rPCObject == null) {
                return null;
            }
            if (charStream.hasChars()) {
                throw new RPCArgException(charStream, "Excess argument characters");
            }
            rPCBatch = new RPCBatch();
            rPCBatch.add(new RPCJob(rPCObject));
        } else if (string.startsWith("[") && string.endsWith("]")) {
            RPCArray rPCArray = RPCArg.readJSONArray(charStream);
            if (rPCArray == null) {
                return null;
            }
            if (charStream.hasChars()) {
                throw new RPCArgException(charStream, "Excess argument characters");
            }
            rPCBatch = new RPCBatch();
            for (Object e : rPCArray) {
                if (!(e instanceof RPCObject)) {
                    throw new RPCArgException("Invalid batch array structure");
                }
                rPCBatch.add(new RPCJob((RPCObject)e));
            }
        } else {
            throw new RPCArgException(charStream, "Not a valid RPC argument");
        }
        return rPCBatch;
    }

    static class CharStream {
        private String string;
        private int length;
        private int pos;
        int lineCount;
        int charCount;

        public CharStream(String string) {
            this.string = string;
            this.length = string.length();
            this.lineCount = 1;
            this.charCount = 1;
        }

        public int getPos() {
            return this.pos;
        }

        public boolean hasChars() {
            return this.pos < this.length;
        }

        public char peekChar() throws RPCArgException {
            if (this.pos >= this.length) {
                throw new RPCArgException("Premature end of stream");
            }
            return this.string.charAt(this.pos);
        }

        public void expectCharAndSkip(Character c) throws RPCArgException {
            if (this.pos >= this.length) {
                throw new RPCArgException("Premature end of stream");
            }
            if (this.string.charAt(this.pos) != c.charValue()) {
                throw new RPCArgException(this, "Expected character '" + c + "'");
            }
            if (c.charValue() == '\n') {
                ++this.lineCount;
                this.charCount = 1;
            } else {
                ++this.charCount;
            }
            ++this.pos;
        }

        public void expectHexCharAndSkip() throws RPCArgException {
            if (this.pos >= this.length) {
                throw new RPCArgException("Premature end of stream");
            }
            char c = Character.toUpperCase(this.string.charAt(this.pos));
            if (c < '0' || c > '9' && c < 'A' || c > 'F') {
                throw new RPCArgException(this, "Expected hex digit");
            }
            ++this.pos;
            ++this.charCount;
        }

        public void expectDigitsAndSkip() throws RPCArgException {
            if (this.pos >= this.length) {
                throw new RPCArgException("Premature end of stream");
            }
            char c = this.string.charAt(this.pos);
            if (c < '0' || c > '9') {
                throw new RPCArgException(this, "Invalid number format");
            }
            ++this.pos;
            ++this.charCount;
            while (this.pos < this.length && (c = this.string.charAt(this.pos)) >= '0' && c <= '9') {
                ++this.pos;
                ++this.charCount;
            }
        }

        public void skipChar() throws RPCArgException {
            if (this.pos >= this.length) {
                throw new RPCArgException("Premature end of stream");
            }
            char c = this.string.charAt(this.pos);
            if (c == '\n') {
                ++this.lineCount;
                this.charCount = 1;
            } else {
                ++this.charCount;
            }
            ++this.pos;
        }

        public void skipWhitespace() {
            char c;
            while (this.pos < this.length && Character.isWhitespace(c = this.string.charAt(this.pos))) {
                if (c == '\n') {
                    ++this.lineCount;
                    this.charCount = 1;
                } else {
                    ++this.charCount;
                }
                ++this.pos;
            }
        }

        public String substring(int n, int n2) {
            return this.string.substring(n, n2);
        }
    }
}

