/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.routes;

import dexlogic.parsec.routes.LocalObjectAgent;
import dexlogic.parsec.routes.RPCInvokeAdapter;
import dexlogic.parsec.routes.SetupArgIO;
import java.util.LinkedHashMap;
import java.util.Map;

public class SetupElement {
    private LocalObjectAgent objectAgent = new LocalObjectAgent();
    private Map<String, String> setupMap;
    private String rpcArg;

    LocalObjectAgent getObjectAgent() {
        return this.objectAgent;
    }

    public SetupElement() {
        this.setupMap = null;
    }

    public SetupElement(Map<String, String> map) {
        this.setupMap = map;
    }

    public SetupElement(String string) {
        this.rpcArg = string;
    }

    public SetupElement(Map<String, String> map, String string) {
        this.setupMap = map;
        this.rpcArg = string;
    }

    public String getSetupArg(String string) {
        if (this.setupMap == null) {
            return null;
        }
        return this.setupMap.get(string);
    }

    public void putSetupArg(String string, String string2) {
        if (this.setupMap == null) {
            this.setupMap = new LinkedHashMap<String, String>();
        }
        this.setupMap.put(string, string2);
    }

    public String getSetupArgs() {
        if (this.setupMap == null) {
            return null;
        }
        if (this.setupMap.size() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.setupMap.entrySet()) {
            SetupArgIO.writeParam(stringBuilder, entry.getKey(), entry.getValue());
        }
        return stringBuilder.toString();
    }

    public String getRPCArg() {
        return this.rpcArg;
    }

    public void updateRPCArg(String string) {
        this.rpcArg = string;
        if (this.objectAgent == null) {
            this.objectAgent = new LocalObjectAgent();
        }
        this.objectAgent.remoteCall(string);
    }

    public synchronized void addInvokeAdapter(RPCInvokeAdapter rPCInvokeAdapter) {
        if (rPCInvokeAdapter == null) {
            return;
        }
        if (this.objectAgent == null) {
            this.objectAgent = new LocalObjectAgent();
        }
        this.objectAgent.addInvokeAdapter(rPCInvokeAdapter);
    }

    public synchronized void removeInvokeAdapter(RPCInvokeAdapter rPCInvokeAdapter) {
        if (rPCInvokeAdapter == null) {
            return;
        }
        if (this.objectAgent != null) {
            this.objectAgent.removeInvokeAdapter(rPCInvokeAdapter);
        }
    }
}

