/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.routes;

import dexlogic.parsec.InternalParsecException;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.routes.FlowGraph;
import dexlogic.parsec.routes.FlowProxyBuilder;
import dexlogic.parsec.routes.LocalObjectAgent;
import dexlogic.parsec.routes.MediaSource;
import dexlogic.parsec.routes.RPCInvokeAdapter;
import dexlogic.parsec.routes.RPCInvokeHandler;
import java.io.File;
import java.net.URI;

public class SourceWriter
implements FlowProxyBuilder {
    private MediaSource mediaSource;

    private String buildGenericAttributes(FlowGraph flowGraph, String string, MediaSource.Element element) {
        Object object;
        Object object2 = "";
        StringBuilder stringBuilder = null;
        LocalObjectAgent localObjectAgent = element.getObjectAgent();
        if (localObjectAgent != null) {
            int n = flowGraph.getNextObjectNum();
            if (n > 0) {
                object2 = " objID='" + n + "'";
                flowGraph.addObjectGateway(n, localObjectAgent);
            }
            if ((object = localObjectAgent.rpcInvokeAdapterArray) != null && n > 0) {
                for (int i = 0; i < ((RPCInvokeAdapter[])object).length; ++i) {
                    RPCInvokeAdapter rPCInvokeAdapter = object[i];
                    RPCInvokeHandler rPCInvokeHandler = flowGraph.createRPCInvokeHandler(n, rPCInvokeAdapter);
                    flowGraph.addInvokeHandler(rPCInvokeAdapter, rPCInvokeHandler);
                    if (!(rPCInvokeAdapter.selector instanceof String)) continue;
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder();
                    } else {
                        stringBuilder.append(";");
                    }
                    stringBuilder.append((String)rPCInvokeAdapter.selector);
                    stringBuilder.append(":\"");
                    int n2 = rPCInvokeHandler.lsnID & 0xFFFF3FFF;
                    stringBuilder.append("s#").append(n2);
                    stringBuilder.append("\"");
                }
            }
        }
        string = ParsecTools.concatSetupParam(string, element.getSetupArgs());
        string = ParsecTools.concatSetupParam(string, stringBuilder == null ? null : stringBuilder.toString());
        Object object3 = string == null ? "" : " setup=' " + string + " '";
        object = ParsecTools.trimString(element.getRPCArg());
        Object object4 = object == null ? "" : " rpc='" + (String)object + "'";
        return (String)object2 + (String)object3 + (String)object4;
    }

    private String buildPlugin(FlowGraph flowGraph, MediaSource.Plugin plugin, StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = new StringBuilder();
        String string = " driverID='" + plugin.driverID + "'";
        stringBuilder2.append("  <pluginDriver" + string + ">\n");
        String string2 = " scheme='" + plugin.scheme + "'";
        String string3 = "P" + flowGraph.getNextPluginServiceNum();
        String string4 = " name='" + string3 + "'";
        Object object = "";
        String string5 = this.buildPatchList(flowGraph, plugin.routing, stringBuilder);
        if (string5 != null) {
            object = " patch='" + string5 + "'";
        }
        String string6 = this.buildGenericAttributes(flowGraph, null, plugin);
        stringBuilder2.append("    <service" + string2 + string4 + (String)object + string6 + " />\n");
        stringBuilder2.append("  </pluginDriver>");
        if (stringBuilder.length() != 0) {
            stringBuilder.insert(0, "\n\n");
        }
        stringBuilder.insert(0, stringBuilder2.toString());
        return string3;
    }

    private String buildPatchList(FlowGraph flowGraph, MediaSource.Routing routing, StringBuilder stringBuilder) {
        String string = null;
        if (routing.plugins.size() != 0) {
            StringBuilder stringBuilder2 = new StringBuilder();
            for (MediaSource.Plugin plugin : routing.plugins) {
                if (!plugin.routing.enabled) continue;
                if (stringBuilder2.length() != 0) {
                    stringBuilder2.append(", ");
                }
                if (plugin.scheme != null && plugin.scheme.length() != 0) {
                    stringBuilder2.append(this.buildPlugin(flowGraph, plugin, stringBuilder));
                    continue;
                }
                String string2 = this.buildPatchList(flowGraph, plugin.routing, stringBuilder);
                if (string2 == null) continue;
                stringBuilder2.append(string2);
            }
            string = stringBuilder2.toString();
        } else if (routing.patch != null) {
            string = routing.patch;
        }
        return string;
    }

    public SourceWriter(MediaSource mediaSource) {
        this.mediaSource = mediaSource;
    }

    public void buildFlowProxy(FlowGraph flowGraph) throws ParsecException {
        Object object;
        String string;
        Object object2;
        String string2;
        Object object3;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (MediaSource.Trunk object42 : this.mediaSource.getFeed().trunks) {
            if (!object42.enabled) continue;
            object3 = "";
            if (object42.trunkName != null && (string2 = object42.trunkName.trim()).length() != 0) {
                object3 = " name='" + string2 + "'";
            }
            object2 = "";
            string = object42.getSetupArgs();
            if (string != null && (string = string.trim()).length() != 0) {
                object2 = " setup=' " + string + " '";
            }
            stringBuilder2.append("      <trunk" + (String)object3 + (String)object2 + ">\n");
            for (MediaSource.Jack jack : object42.jacks) {
                String string3;
                if (!jack.routing.enabled) continue;
                Object object4 = "";
                if (jack.jackName != null && (string3 = jack.jackName.trim()).length() != 0) {
                    object4 = " name='" + string3 + "'";
                }
                Object object5 = "";
                String string4 = this.buildPatchList(flowGraph, jack.routing, stringBuilder);
                if (string4 != null) {
                    object5 = " patch='" + string4 + "'";
                }
                Object object6 = "";
                String string5 = jack.getSetupArgs();
                if (string5 != null && (string5 = string5.trim()).length() != 0) {
                    object6 = " setup=' " + string5 + " '";
                }
                stringBuilder2.append("        <jack" + (String)object4 + (String)object5 + (String)object6 + " />\n");
            }
            stringBuilder2.append("      </trunk>\n");
        }
        URI uRI = this.mediaSource.getFeed().absoluteURI;
        string2 = uRI.getScheme();
        if (string2 == null || string2.equals("file")) {
            object3 = new File(uRI);
            object2 = "path:\"" + ((File)object3).getPath() + "\"";
            string = this.buildGenericAttributes(flowGraph, (String)object2, this.mediaSource.getFeed());
            object = "  <sourceDriver driverID='FileReader'>\n    <feed scheme='" + this.mediaSource.getFeed().scheme + "' name='#1' " + string + ">\n";
        } else if (string2.equals("imsp")) {
            object = "  <sourceDriver driverID='IDNServer'>\n    <feed scheme='" + this.mediaSource.getFeed().scheme + "' name='#1' setup='pullAddress:\"" + uRI.getAuthority() + "\"'>\n";
        } else {
            throw new InternalParsecException("Invalid URI scheme" + string2);
        }
        object3 = "    </feed>\n  </sourceDriver>\n";
        stringBuilder2.insert(0, (String)object);
        stringBuilder2.append((String)object3);
        if (stringBuilder.length() != 0) {
            stringBuilder2.insert(0, "\n\n");
            stringBuilder2.insert(0, stringBuilder.toString());
        }
        stringBuilder2.insert(0, "<dxcSetup>\n");
        stringBuilder2.append("</dxcSetup>");
        flowGraph.setXML(stringBuilder2.toString());
    }
}

