/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.devlog;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public class WLogArea
extends JComponent
implements Scrollable {
    private ArrayList<LogLine> logLines = new ArrayList();
    private Font boldFont;
    private int columnWidth;
    private int rowHeight;
    private int baselineOffset;
    private int preferredColumnCount = 80;
    private int preferredRowCount = 25;

    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.columnWidth = fontMetrics.charWidth('m');
        }
        return this.columnWidth;
    }

    protected int getRowHeight() {
        if (this.rowHeight == 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.rowHeight = fontMetrics.getHeight();
        }
        return this.rowHeight;
    }

    protected int getBaselineOffset() {
        if (this.baselineOffset == 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.baselineOffset = fontMetrics.getLeading() / 2 + fontMetrics.getAscent();
        }
        return this.baselineOffset;
    }

    public void appendLines(ArrayList<LogLine> arrayList) {
        Container container;
        JViewport jViewport = null;
        for (container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JViewport)) continue;
            jViewport = (JViewport)container;
            break;
        }
        container = null;
        for (Container container2 = jViewport; container2 != null; container2 = container2.getParent()) {
            if (!(container2 instanceof JScrollPane)) continue;
            container = ((JScrollPane)container2).getVerticalScrollBar();
            break;
        }
        boolean bl = false;
        if (container != null && ((JScrollBar)container).getValue() + ((JScrollBar)container).getVisibleAmount() == ((JScrollBar)container).getMaximum()) {
            bl = true;
        }
        this.logLines.addAll(arrayList);
        int n = this.logLines.size();
        if (n > 100000) {
            this.logLines.subList(0, n - 100000).clear();
        }
        if (jViewport != null) {
            jViewport.invalidate();
            jViewport.validate();
        }
        if (bl) {
            ((JScrollBar)container).setValue(((JScrollBar)container).getMaximum());
        }
        this.repaint();
    }

    public void dump(OutputStream outputStream) throws IOException {
        for (LogLine logLine : this.logLines) {
            int n = logLine.channel < 0 ? 63 : (logLine.channel < 10 ? (int)((char)(48 + logLine.channel)) : (logLine.channel < 36 ? (int)((char)(65 + (logLine.channel - 10))) : 63));
            outputStream.write((byte)n);
            outputStream.write(124);
            outputStream.write(32);
            String string = logLine.text;
            int n2 = string == null ? 0 : string.length();
            for (int i = 0; i < n2; ++i) {
                outputStream.write((byte)string.charAt(i));
            }
            outputStream.write(10);
        }
    }

    public void load(InputStream inputStream) throws IOException {
        ArrayList<LogLine> arrayList = new ArrayList<LogLine>();
        while (inputStream.available() > 0) {
            int n = inputStream.read();
            if (n >= 48 && n <= 57) {
                n -= 48;
            } else if (n >= 65 && n <= 90) {
                n = n - 65 + 10;
            } else if (n == 63) {
                n = -1;
            } else {
                throw new IOException("Invalid file format");
            }
            if (inputStream.available() <= 0) {
                throw new IOException("Premature end of file");
            }
            int n2 = inputStream.read();
            if (n2 != 124 && n2 != 62) {
                throw new IOException("Invalid file format");
            }
            if (inputStream.available() <= 0) {
                throw new IOException("Premature end of file");
            }
            if (inputStream.read() != 32) {
                throw new IOException("Invalid file format");
            }
            StringBuilder stringBuilder = new StringBuilder();
            while (true) {
                if (inputStream.available() <= 0) {
                    throw new IOException("Premature end of file");
                }
                char c = (char)inputStream.read();
                if (c == '\n') break;
                stringBuilder.append(c);
            }
            String string = stringBuilder.toString();
            arrayList.add(new LogLine(n, string));
        }
        this.appendLines(arrayList);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.boldFont = font == null ? null : new Font(font.getName(), 1, font.getSize());
        this.rowHeight = 0;
        this.columnWidth = 0;
        this.baselineOffset = 0;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (dimension == null) {
            dimension = new Dimension();
        }
        Insets insets = this.getInsets();
        dimension.width = insets.left + insets.right;
        dimension.height = insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension == null) {
            dimension = new Dimension(100, 100);
        }
        int n = this.preferredColumnCount;
        int n2 = Math.max(this.logLines.size() + 1, this.preferredRowCount);
        Insets insets = this.getInsets();
        dimension.width = Math.max(dimension.width, insets.left + n * this.getColumnWidth() + insets.right);
        dimension.height = Math.max(dimension.height, insets.top + n2 * this.getRowHeight() + insets.bottom);
        return dimension;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        if (dimension == null) {
            dimension = new Dimension();
        }
        dimension.width = Integer.MAX_VALUE;
        dimension.height = Integer.MAX_VALUE;
        return dimension;
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            rectangle = new Rectangle(dimension);
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = insets.top + this.getBaselineOffset();
        int n3 = (rectangle.y - insets.top) / this.getRowHeight();
        int n4 = (rectangle.y + rectangle.height - insets.top) / this.getRowHeight();
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Font font = this.getFont();
        Color color = new Color(160, 160, 160);
        Color color2 = new Color(56, 149, 6);
        Color color3 = new Color(239, 41, 41);
        int n5 = this.logLines.size();
        for (int i = n3; i <= n4 && i < n5; ++i) {
            LogLine logLine = this.logLines.get(i);
            if (logLine.channel == 0) {
                graphics.setFont(font);
                graphics.setColor(color);
            } else if (logLine.channel == 1) {
                graphics.setFont(font);
                graphics.setColor(color2);
            } else if (logLine.channel == 2) {
                graphics.setFont(this.boldFont != null ? this.boldFont : this.getFont());
                graphics.setColor(color3);
            } else {
                graphics.setFont(font);
                graphics.setColor(this.getForeground());
            }
            graphics.drawString(logLine.text, n, n2 + i * this.rowHeight);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.getPreferredSize();
        if (dimension == null) {
            dimension = new Dimension(100, 100);
        }
        Insets insets = this.getInsets();
        dimension.width = this.preferredColumnCount == 0 ? dimension.width : insets.left + this.preferredColumnCount * this.getColumnWidth() + insets.right;
        dimension.height = this.preferredRowCount == 0 ? dimension.height : insets.top + this.preferredRowCount * this.getRowHeight() + insets.bottom;
        return dimension;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return this.getRowHeight();
            }
            case 0: {
                return this.getColumnWidth();
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return rectangle.height;
            }
            case 0: {
                return rectangle.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container container = SwingUtilities.getUnwrappedParent(this);
        if (container instanceof JViewport) {
            return container.getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container container = SwingUtilities.getUnwrappedParent(this);
        if (container instanceof JViewport) {
            return container.getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public class LogLine {
        public int channel;
        public String text;

        public LogLine(int n, String string) {
            this.channel = n;
            this.text = string;
        }
    }
}

