/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.esa;

import dexlogic.io.esa.ESAException;
import dexlogic.io.esa.ESAFactory;
import dexlogic.io.esa.ESALink;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;

public class ESAConcurrentLink
extends ESALink {
    private Selector linkSelector;
    private DatagramChannel passChannel;

    @Override
    public boolean isOpen() {
        return this.readChannel != null && this.readChannel.isOpen() && this.passChannel != null && this.passChannel.isOpen() && super.isOpen();
    }

    @Override
    public void open(InetAddress inetAddress) throws IOException {
        InetAddress inetAddress2 = InetAddress.getLoopbackAddress();
        this.openLinkChannel(inetAddress);
        this.linkSelector = Selector.open();
        this.linkChannel.register(this.linkSelector, 1);
        this.readChannel = DatagramChannel.open();
        this.readChannel.configureBlocking(false);
        this.readChannel.bind(new InetSocketAddress(inetAddress2, 0));
        int n = this.readChannel.socket().getLocalPort();
        this.openReadSelector();
        this.passChannel = DatagramChannel.open();
        this.passChannel.configureBlocking(false);
        this.passChannel.connect(new InetSocketAddress(inetAddress2, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.linkSelector != null && this.linkSelector.isOpen()) {
                this.linkSelector.close();
            }
        }
        finally {
            this.linkSelector = null;
            try {
                if (this.readChannel != null && this.readChannel.isOpen()) {
                    this.readChannel.close();
                }
            }
            finally {
                this.readChannel = null;
                try {
                    if (this.passChannel != null && this.passChannel.isOpen()) {
                        this.passChannel.close();
                    }
                }
                finally {
                    this.passChannel = null;
                    super.close();
                }
            }
        }
    }

    public int receive(ByteBuffer byteBuffer) throws IOException, ESAException {
        while (this.linkSelector.select() > 0) {
            Iterator<SelectionKey> iterator = this.linkSelector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                iterator.remove();
                SelectableChannel selectableChannel = selectionKey.channel();
                if (selectableChannel == this.linkChannel) {
                    byteBuffer.clear();
                    this.linkChannel.receive(byteBuffer);
                    byteBuffer.flip();
                    int n = ESAFactory.getMessageID(byteBuffer);
                    if (n >= 8192 && n <= 12287) {
                        ESAFactory.skipHeaders(byteBuffer);
                        return n;
                    }
                    this.passChannel.write(byteBuffer);
                    continue;
                }
                throw new IOException("ESA(receive): Select returned invalid channel / selection key");
            }
        }
        return 0;
    }
}

