/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.esa;

import dexlogic.io.esa.ESALoadListener;

public class ESAConsoleLoadListener
implements ESALoadListener {
    private int minValue;
    private int maxValue;
    private int cursor;

    @Override
    public void loadLog(String string) {
        System.out.println(string);
    }

    @Override
    public void loadCopyStarted(int n, int n2) {
        this.minValue = n;
        this.maxValue = n2;
        this.cursor = 0;
    }

    @Override
    public void loadCopyProgress(int n) {
        if (n < this.minValue) {
            n = this.minValue;
        }
        if (n > this.maxValue) {
            n = this.maxValue;
        }
        int n2 = (int)(100.0 * ((double)n - (double)this.minValue) / ((double)this.maxValue - (double)this.minValue));
        while (this.cursor <= n2) {
            if (this.cursor % 10 == 0) {
                System.out.print(this.cursor);
            } else {
                System.out.print(".");
            }
            this.cursor += 2;
        }
    }

    @Override
    public void loadCopyEnded() {
        System.out.println();
    }
}

