/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.esa;

import dexlogic.io.esa.ESAConstants;
import dexlogic.io.esa.ESAException;
import dexlogic.io.esa.ESATools;
import dexlogic.io.esa.chunks.ESAChunk;
import dexlogic.io.esa.chunks.ESAIconRspChunk;
import dexlogic.io.esa.chunks.ESAIdentRspChunk;
import dexlogic.io.esa.chunks.ESALabelRspChunk;
import dexlogic.io.esa.chunks.ESANameRspChunk;
import dexlogic.io.esa.chunks.ESAPingReqChunk;
import dexlogic.io.esa.chunks.ESAPingRspChunk;
import dexlogic.io.esa.chunks.ESAPropertiesRspChunk;
import dexlogic.io.esa.chunks.IPLDumpRspChunk;
import java.nio.ByteBuffer;
import java.util.Random;

public class ESAFactory
implements ESAConstants {
    private static Random random = new Random();

    public static void writeMessage(ByteBuffer byteBuffer, ESAChunk eSAChunk) throws ESAException {
        eSAChunk.writeTo(byteBuffer);
    }

    public static void writeDatagram(ByteBuffer byteBuffer, ESAChunk eSAChunk) throws ESAException {
        byteBuffer.clear();
        byteBuffer.putInt(random.nextInt());
        byteBuffer.putInt(ESATools.crc32(byteBuffer.array(), 0, 4));
        byteBuffer.position(8);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        ESAFactory.writeMessage(byteBuffer2, eSAChunk);
        byteBuffer.limit(byteBuffer.position() + byteBuffer2.limit());
    }

    public static ESAChunk readMessage(ByteBuffer byteBuffer) throws ESAException {
        if (byteBuffer.limit() < 4) {
            throw new ESAException(-1, "[esaRead] Message header length " + byteBuffer.limit());
        }
        int n = byteBuffer.getShort(2) & 0xFFFF;
        if (byteBuffer.limit() != n) {
            String string = "packet " + n + ", wire " + byteBuffer.limit();
            throw new ESAException(-1, "[esaRead] Size mismatch, " + string);
        }
        int n2 = byteBuffer.getShort(0) & 0xFFFF;
        String string = "0x" + ESATools.toShortHexString(n2);
        if (n2 == 16) {
            byteBuffer.position(4);
            int n3 = byteBuffer.getShort() & 0xFFFF;
            byte[] byArray = byteBuffer.array();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n5 = byteBuffer.limit() - byteBuffer.position();
            String string2 = new String(byArray, n4, n5);
            if (n3 < 0) {
                n3 = 0;
            }
            throw new ESAException(n3, string2);
        }
        if (n2 == 33) {
            return new ESAPingReqChunk(byteBuffer);
        }
        if (n2 == 32) {
            return new ESAPingRspChunk(byteBuffer);
        }
        if (n2 == 257) {
            return new ESAChunk(n2, byteBuffer);
        }
        if (n2 == 256) {
            return new ESAIdentRspChunk(byteBuffer);
        }
        if (n2 == 273) {
            throw new ESAException(-1, "[esaRead] Not implemented " + string);
        }
        if (n2 == 272) {
            return new ESAPropertiesRspChunk(byteBuffer);
        }
        if (n2 == 289) {
            return new ESAChunk(n2, byteBuffer);
        }
        if (n2 == 288) {
            return new ESALabelRspChunk(byteBuffer);
        }
        if (n2 == 293) {
            return new ESAChunk(n2, byteBuffer);
        }
        if (n2 == 292) {
            return new ESANameRspChunk(byteBuffer);
        }
        if (n2 == 297) {
            return new ESAChunk(n2, byteBuffer);
        }
        if (n2 == 296) {
            return new ESAIconRspChunk(byteBuffer);
        }
        if (n2 == 1025) {
            return new ESAChunk(n2, byteBuffer);
        }
        if (n2 == 1024) {
            return new ESAChunk(n2, byteBuffer);
        }
        if (n2 == 4097) {
            throw new ESAException(-1, "[esaRead] Not implemented " + string);
        }
        if (n2 == 4096) {
            return new ESAChunk(n2, byteBuffer);
        }
        if (n2 == 4353) {
            throw new ESAException(-1, "[esaRead] Not implemented " + string);
        }
        if (n2 == 4352) {
            return new IPLDumpRspChunk(byteBuffer);
        }
        if (n2 == 4609) {
            throw new ESAException(-1, "[esaRead] Not implemented " + string);
        }
        if (n2 == 4608) {
            return new ESAChunk(n2, byteBuffer);
        }
        if (n2 == 4625) {
            throw new ESAException(-1, "[esaRead] Not implemented " + string);
        }
        if (n2 == 4624) {
            return new ESAChunk(n2, byteBuffer);
        }
        if (n2 == 4641) {
            throw new ESAException(-1, "[esaRead] Not implemented " + string);
        }
        if (n2 == 4640) {
            return new ESAChunk(n2, byteBuffer);
        }
        if (n2 == 4649) {
            throw new ESAException(-1, "[esaRead] Not implemented " + string);
        }
        if (n2 == 4648) {
            return new ESAChunk(n2, byteBuffer);
        }
        System.out.println("Undecoded message ID 0x" + string);
        return new ESAChunk(n2, byteBuffer);
    }

    public static ESAChunk readDatagram(ByteBuffer byteBuffer) throws ESAException {
        if (byteBuffer.limit() < 8) {
            throw new ESAException(-1, "[esaRead] Datagram header length " + byteBuffer.limit());
        }
        if (ESATools.crc32(byteBuffer.array(), 0, 4) != byteBuffer.getInt(4)) {
            throw new ESAException(-1, "[esaRead] Datagram fingerprint");
        }
        byteBuffer.position(8);
        return ESAFactory.readMessage(byteBuffer.slice());
    }

    public static int getMessageID(ByteBuffer byteBuffer) {
        if (byteBuffer.limit() < 12) {
            return -1;
        }
        if (ESATools.crc32(byteBuffer.array(), 0, 4) != byteBuffer.getInt(4)) {
            return -2;
        }
        short s = (short)(byteBuffer.limit() - 8);
        if (s != byteBuffer.getShort(10)) {
            return -3;
        }
        int n = byteBuffer.getShort(8) & 0xFFFF;
        return n;
    }

    public static void skipHeaders(ByteBuffer byteBuffer) {
        byteBuffer.position(12);
    }
}

