/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.esa;

import dexlogic.io.esa.ESARoute;
import dexlogic.io.esa.ESAUnitID;
import java.net.InetAddress;
import java.util.Arrays;

public class ESAHost {
    ESAUnitID unitID;
    int adminDialogID;
    int adminParam;
    int layoutDialogID;
    int layoutParam;
    ESARoute[] routes;

    void addRoute(InetAddress inetAddress, InetAddress inetAddress2, boolean bl) {
        int n;
        for (n = 0; n < this.routes.length; ++n) {
            if (!this.routes[n].remoteAddress.equals(inetAddress)) continue;
            throw new Error("[ESAHost::addRoute] Duplicate route");
        }
        n = this.routes.length;
        this.routes = Arrays.copyOf(this.routes, n + 1);
        this.routes[n] = new ESARoute(inetAddress2, inetAddress, bl);
    }

    void removeRoute(ESARoute eSARoute) {
        int n;
        for (n = 0; n < this.routes.length && this.routes[n] != eSARoute; ++n) {
        }
        if (n >= this.routes.length) {
            throw new Error("[ESAHost::removeRoute] No match");
        }
        ++n;
        while (n < this.routes.length) {
            this.routes[n - 1] = this.routes[n];
            ++n;
        }
        this.routes = Arrays.copyOf(this.routes, this.routes.length - 1);
    }

    public ESAHost(ESAUnitID eSAUnitID) {
        this.unitID = eSAUnitID;
        this.routes = new ESARoute[0];
    }

    public ESAUnitID getUnitID() {
        return this.unitID;
    }

    public ESARoute[] getRoutes() {
        return this.routes;
    }

    public ESARoute getDefaultRoute() {
        return this.routes[0];
    }

    public boolean isReachable() {
        return this.routes[0].reachable;
    }

    public int getAdminDialogID() {
        return this.adminDialogID;
    }

    public int getAdminParam() {
        return this.adminParam;
    }

    public int getLayoutDialogID() {
        return this.layoutDialogID;
    }

    public int getLayoutParam() {
        return this.layoutParam;
    }
}

