/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.esa;

import dexlogic.io.esa.ESAException;
import dexlogic.io.esa.ESAFactory;
import dexlogic.io.esa.chunks.ESAChunk;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;

public class ESALink {
    private ByteBuffer transferBuffer = ByteBuffer.allocate(1500);
    protected DatagramChannel linkChannel;
    protected DatagramChannel readChannel;
    protected Selector readSelector;

    protected void openLinkChannel(InetAddress inetAddress) throws IOException {
        this.linkChannel = DatagramChannel.open();
        this.linkChannel.configureBlocking(false);
        this.linkChannel.connect(new InetSocketAddress(inetAddress, 62018));
    }

    protected void openReadSelector() throws IOException {
        this.readSelector = Selector.open();
        this.readChannel.register(this.readSelector, 1);
    }

    public boolean isOpen() {
        return this.linkChannel != null && this.linkChannel.isOpen();
    }

    public void open(InetAddress inetAddress) throws IOException {
        this.openLinkChannel(inetAddress);
        this.readChannel = this.linkChannel;
        this.openReadSelector();
    }

    public void close() throws IOException {
        try {
            if (this.readSelector != null && this.readSelector.isOpen()) {
                this.readSelector.close();
            }
        }
        finally {
            this.readSelector = null;
            try {
                if (this.linkChannel != null && this.linkChannel.isOpen()) {
                    this.linkChannel.close();
                }
            }
            finally {
                this.linkChannel = null;
                this.readChannel = null;
            }
        }
    }

    public ESAChunk exchange(ESAChunk eSAChunk, int n) throws IOException, ESAException {
        SelectableChannel selectableChannel;
        SelectionKey selectionKey;
        Iterator<SelectionKey> iterator;
        if (this.readSelector.selectNow() != 0) {
            iterator = this.readSelector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                selectionKey = iterator.next();
                iterator.remove();
                selectableChannel = selectionKey.channel();
                if (selectableChannel == this.readChannel) {
                    this.transferBuffer.clear();
                    this.readChannel.receive(this.transferBuffer);
                    continue;
                }
                throw new IOException("ESA(exchange): Select returned invalid channel / selection key");
            }
        }
        ESAFactory.writeDatagram(this.transferBuffer, eSAChunk);
        this.transferBuffer.rewind();
        this.linkChannel.write(this.transferBuffer);
        if (this.readSelector.select(n) != 0 && (iterator = this.readSelector.selectedKeys().iterator()).hasNext()) {
            selectionKey = iterator.next();
            iterator.remove();
            selectableChannel = selectionKey.channel();
            if (selectableChannel == this.readChannel) {
                this.transferBuffer.clear();
                this.readChannel.receive(this.transferBuffer);
                this.transferBuffer.flip();
                return ESAFactory.readDatagram(this.transferBuffer);
            }
            throw new IOException("ESA(exchange): Select returned invalid channel / selection key");
        }
        throw new IOException("ESA(exchange): Receive timeout (" + eSAChunk.getDecodedID() + ", timeout=" + n + ")");
    }
}

