/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.esa;

import dexlogic.io.esa.ESAConnection;
import dexlogic.io.esa.ESAConstants;
import dexlogic.io.esa.ESAFile;
import dexlogic.io.esa.ESAFileDump;
import dexlogic.io.esa.ESALoadListener;
import dexlogic.io.esa.ESATools;
import dexlogic.io.esa.chunks.ESAIconRspChunk;
import dexlogic.io.esa.chunks.ESAIdentRspChunk;
import dexlogic.io.esa.chunks.ESALabelRspChunk;
import dexlogic.io.esa.chunks.ESANameRspChunk;
import dexlogic.io.esa.chunks.ESAPropertiesRspChunk;
import dexlogic.io.esa.chunks.IPLDumpRspChunk;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Hashtable;

public class ESATarget
implements ESAConstants {
    ESAConnection connection = new ESAConnection();
    private byte[] unitID;
    private int firmwareMode;
    private int protocolVersion;
    private int adminDialogID;
    private int adminParam;
    private int layoutDialogID;
    private int layoutParam;
    private static final int FILE_FINGERPRINT = 1115316380;

    public boolean identMatch(byte[] byArray) {
        return Arrays.equals(byArray, this.unitID);
    }

    public boolean isConnectionOpen() {
        return this.connection.isOpen();
    }

    public void openConnection(InetAddress inetAddress, InetAddress inetAddress2) throws IOException {
        this.connection.open(inetAddress, inetAddress2);
        ESAIdentRspChunk eSAIdentRspChunk = this.connection.retrieveIdent();
        if (eSAIdentRspChunk == null) {
            throw new IOException("ESA(openConnection): Invalid connection response");
        }
        this.firmwareMode = eSAIdentRspChunk.getFirmwareMode();
        this.protocolVersion = eSAIdentRspChunk.getProtocolVersion();
        this.adminDialogID = eSAIdentRspChunk.getAdminDialogID();
        this.adminParam = eSAIdentRspChunk.getAdminParam();
        this.layoutDialogID = eSAIdentRspChunk.getLayoutDialogID();
        this.layoutParam = eSAIdentRspChunk.getLayoutParam();
        this.unitID = eSAIdentRspChunk.getUnitID();
    }

    public void openConnection(InetAddress inetAddress) throws IOException {
        this.openConnection(inetAddress, null);
    }

    public void closeConnection() throws IOException {
        this.connection.close();
    }

    public Hashtable retrieveProperties() throws IOException {
        if (this.connection == null || !this.connection.isOpen()) {
            throw new IOException("ESA: Invalid connection state");
        }
        ESAPropertiesRspChunk eSAPropertiesRspChunk = this.connection.retrieveProperties();
        if (eSAPropertiesRspChunk == null) {
            throw new IOException("ESA(retrieveProperties): Invalid connection response");
        }
        return eSAPropertiesRspChunk.getProperties();
    }

    public String retrieveLabel() throws IOException {
        if (this.connection == null || !this.connection.isOpen()) {
            throw new IOException("ESA: Invalid connection state");
        }
        ESALabelRspChunk eSALabelRspChunk = this.connection.retrieveLabel();
        if (eSALabelRspChunk == null) {
            throw new IOException("ESA(retrieveLabel): Invalid connection response");
        }
        return eSALabelRspChunk.getLabel();
    }

    public String retrieveName() throws IOException {
        if (this.connection == null || !this.connection.isOpen()) {
            throw new IOException("ESA: Invalid connection state");
        }
        ESANameRspChunk eSANameRspChunk = this.connection.retrieveName();
        if (eSANameRspChunk == null) {
            throw new IOException("ESA(retrieveName): Invalid connection response");
        }
        return eSANameRspChunk.getName();
    }

    public byte[] retrieveIconBytes() throws IOException {
        if (this.connection == null || !this.connection.isOpen()) {
            throw new IOException("ESA: Invalid connection state");
        }
        ESAIconRspChunk eSAIconRspChunk = this.connection.retrieveIcon();
        if (eSAIconRspChunk == null) {
            throw new IOException("ESA(retrieveIcon): Invalid connection response");
        }
        return eSAIconRspChunk.getIconBytes();
    }

    public void rebootTarget(int n, int n2, ESALoadListener eSALoadListener) throws IOException {
        if (this.connection == null || !this.connection.isOpen()) {
            throw new IOException("ESA: Invalid connection state");
        }
        this.connection.execReboot(n, n2, eSALoadListener);
        for (int i = 0; i < 40; ++i) {
            if (!this.connection.execPing(250)) continue;
            return;
        }
        throw new IOException("ESA(reboot): No answer from target");
    }

    public void update(ESAFile eSAFile, ESALoadListener eSALoadListener) throws IOException {
        if (this.connection == null || !this.connection.isOpen()) {
            throw new IOException("ESA: Invalid connection state");
        }
        if (eSAFile.isDataImage()) {
            eSALoadListener.loadLog(eSAFile.getName() + ": Preparing data image bytes.");
            byte[] byArray = ESATarget.createDataImage(eSAFile);
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.connection.loadDataImage(byArray, eSAFile.getSelector(), eSAFile.getAddress(), eSALoadListener);
            this.rebootTarget(0, 0, eSALoadListener);
        } else {
            eSALoadListener.loadLog(eSAFile.getName() + ": Preparing file image bytes.");
            byte[] byArray = ESATarget.createFileImage(eSAFile);
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.connection.loadFileImage(byArray, eSAFile.getSelector(), eSAFile.getAddress(), eSALoadListener);
            this.rebootTarget(0, 0, eSALoadListener);
        }
    }

    public void load(ESAFile eSAFile, ESALoadListener eSALoadListener) throws IOException {
        if (this.connection == null || !this.connection.isOpen()) {
            throw new IOException("ESA: Invalid connection state");
        }
        if (eSAFile.isDataImage()) {
            byte[] byArray = ESATarget.createDataImage(eSAFile);
            this.connection.loadDataImage(byArray, eSAFile.getSelector(), eSAFile.getAddress(), eSALoadListener);
        } else {
            byte[] byArray = ESATarget.createFileImage(eSAFile);
            this.connection.loadFileImage(byArray, eSAFile.getSelector(), eSAFile.getAddress(), eSALoadListener);
        }
    }

    public ESAFileDump dumpFile(int n, int n2) throws IOException {
        int n3;
        if (this.connection == null || !this.connection.isOpen()) {
            throw new IOException("ESA: Invalid connection state");
        }
        IPLDumpRspChunk iPLDumpRspChunk = this.connection.retrieveDump(n, n2, 64);
        byte[] byArray = iPLDumpRspChunk.getDumpBytes();
        if (ESATools.readInt(byArray, 0) != 1115316380) {
            throw new IOException("ESA(dumpFile): Invalid fingerprint");
        }
        int n4 = ESATools.crc32(byArray, 4, 56);
        if (ESATools.readInt(byArray, 60) != n4) {
            throw new IOException("ESA(dumpFile): Invalid header CRC");
        }
        int n5 = ESATools.readInt(byArray, 4);
        long l = ESATools.readLong(byArray, 8);
        String string = ESATools.readStringField(byArray, 16, 32);
        byte[] byArray2 = new byte[n5];
        int n6 = 0;
        for (int i = n5; i > 0; i -= n3) {
            n3 = i;
            if (n3 > 1024) {
                n3 = 1024;
            }
            IPLDumpRspChunk iPLDumpRspChunk2 = this.connection.retrieveDump(n, n2 + 64 + n6, n3);
            byte[] byArray3 = iPLDumpRspChunk2.getDumpBytes();
            System.arraycopy(byArray3, 0, byArray2, n6, n3);
            n6 += n3;
        }
        IPLDumpRspChunk iPLDumpRspChunk3 = this.connection.retrieveDump(n, n2 + 64 + n5, 4);
        byte[] byArray4 = iPLDumpRspChunk3.getDumpBytes();
        n3 = ESATools.crc32(byArray2, 0, n5);
        if (ESATools.readInt(byArray4, 0) != n3) {
            throw new IOException("ESA(dumpFile): Invalid data CRC");
        }
        return new ESAFileDump(string, l, n, n2, byArray2);
    }

    public static byte[] createFileImage(File file) throws IOException {
        String string = file.getName();
        if (!file.exists()) {
            throw new IOException("ESA(createImage): File does not exist " + string);
        }
        if (!file.canRead()) {
            throw new IOException("ESA(createImage): Can't read file " + string);
        }
        if (string == null || string.length() == 0 || string.length() >= 32) {
            throw new IOException("ESA(createImage): Invalid file name " + string);
        }
        long l = file.lastModified();
        if (l <= 0L) {
            throw new IOException("ESA(createImage): Invalid file modification time " + l);
        }
        long l2 = file.length();
        if (l2 <= 0L || l2 > 0xFFFFFFFFL) {
            throw new IOException("ESA(createImage): Invalid file length " + l2);
        }
        int n = (int)l2;
        int n2 = 64;
        int n3 = n2 + n;
        int n4 = n3 + 4;
        byte[] byArray = new byte[n4];
        ESATools.writeInt(byArray, 0, 1115316380);
        ESATools.writeInt(byArray, 4, n);
        ESATools.writeLong(byArray, 8, l);
        ESATools.writeTermStringField(byArray, 16, string, 32);
        ESATools.writeLong(byArray, 48, System.currentTimeMillis());
        ESATools.writeInt(byArray, 56, 0);
        int n5 = ESATools.crc32(byArray, 4, 56);
        ESATools.writeInt(byArray, 60, n5);
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(byArray, n2, n);
        fileInputStream.close();
        int n6 = ESATools.crc32(byArray, n2, n);
        ESATools.writeInt(byArray, n3, n6);
        return byArray;
    }

    public static byte[] createDataImage(File file) throws IOException {
        int n;
        String string = file.getName();
        if (!file.exists()) {
            throw new IOException("ESA(createImage): File does not exist " + string);
        }
        if (!file.canRead()) {
            throw new IOException("ESA(createImage): Can't read file " + string);
        }
        long l = file.length();
        if (l <= 0L || l > 0xFFFFFFFFL) {
            throw new IOException("ESA(createImage): Invalid file length " + l);
        }
        int n2 = n = (int)l;
        byte[] byArray = new byte[n2];
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(byArray, 0, n);
        fileInputStream.close();
        return byArray;
    }
}

