/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.esa;

import dexlogic.io.esa.ESAConstants;
import dexlogic.io.esa.ESAException;
import dexlogic.io.esa.ESAFactory;
import dexlogic.io.esa.ESAIdent;
import dexlogic.io.esa.ESAUnitID;
import dexlogic.io.esa.chunks.ESAChunk;
import dexlogic.io.esa.chunks.ESAIdentRspChunk;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class ESATracker
implements ESAConstants {
    private static final int SCAN_TIMEOUT_MS = 250;
    private static final int PING_TIMEOUT_MS = 100;

    private static ScanEntry[] getScanList() {
        Vector<ScanEntry> vector = new Vector<ScanEntry>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface == null || networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                    if (interfaceAddress == null || interfaceAddress.getAddress() == null || interfaceAddress.getBroadcast() == null) continue;
                    vector.add(new ScanEntry(networkInterface, interfaceAddress));
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return vector.toArray(new ScanEntry[vector.size()]);
    }

    private static ESAUnitID createUnitID(InetAddress inetAddress, ESAIdentRspChunk eSAIdentRspChunk) {
        byte[] byArray = eSAIdentRspChunk.getUnitID();
        if (byArray == null || byArray.length == 0) {
            byte[] byArray2 = inetAddress.getAddress();
            byArray = new byte[1 + byArray2.length];
            byArray[0] = 4;
            System.arraycopy(byArray2, 0, byArray, 1, byArray2.length);
        }
        return new ESAUnitID(byArray);
    }

    private static void logIdent(ESAIdent eSAIdent) {
        String string = eSAIdent.reachable ? "" : " (unreachable)";
        System.out.println(eSAIdent.unitID.toString() + " at " + eSAIdent.remoteAddress + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enumHosts(Vector<ESAIdent> vector, ScanEntry scanEntry, InetAddress inetAddress) {
        block47: {
            DatagramChannel datagramChannel = null;
            AbstractInterruptibleChannel abstractInterruptibleChannel = null;
            Selector selector = null;
            Hashtable<ESAUnitID, ESAIdent> hashtable = new Hashtable<ESAUnitID, ESAIdent>();
            try {
                Object object;
                Object object2;
                Object object3;
                datagramChannel = DatagramChannel.open();
                datagramChannel.socket().setBroadcast(true);
                datagramChannel.configureBlocking(false);
                abstractInterruptibleChannel = DatagramChannel.open();
                ((AbstractSelectableChannel)abstractInterruptibleChannel).configureBlocking(false);
                Object object4 = null;
                InetSocketAddress inetSocketAddress = null;
                if (scanEntry != null) {
                    object3 = scanEntry.networkInterface;
                    object2 = scanEntry.interfaceAddress;
                    System.out.println("Scan(interface, " + ((NetworkInterface)object3).getName() + "): " + object2);
                    object4 = ((InterfaceAddress)object2).getAddress();
                    object = new byte[]{-1, -1, -1, -1};
                    inetSocketAddress = new InetSocketAddress(InetAddress.getByAddress((byte[])object), 62018);
                } else {
                    System.out.println("Scan(address): " + inetAddress);
                    inetSocketAddress = new InetSocketAddress(inetAddress, 62018);
                }
                datagramChannel.bind(new InetSocketAddress((InetAddress)object4, 0));
                selector = Selector.open();
                datagramChannel.register(selector, 1);
                ((SelectableChannel)abstractInterruptibleChannel).register(selector, 1);
                object3 = new ESAChunk(257);
                object2 = ByteBuffer.allocate(1500);
                ESAFactory.writeDatagram((ByteBuffer)object2, (ESAChunk)object3);
                ((ByteBuffer)object2).rewind();
                if (datagramChannel.send((ByteBuffer)object2, inetSocketAddress) <= 0) {
                    throw new IOException("Insufficient send buffer");
                }
                object = ByteBuffer.allocate(1500);
                block35: while (true) {
                    if (selector.select(250L) <= 0) {
                        break block47;
                    }
                    Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
                    while (true) {
                        ESAIdent eSAIdent;
                        ESAUnitID eSAUnitID;
                        ESAIdentRspChunk eSAIdentRspChunk;
                        ESAChunk eSAChunk;
                        InetAddress inetAddress2;
                        SocketAddress socketAddress;
                        if (!iterator.hasNext()) continue block35;
                        SelectionKey selectionKey = iterator.next();
                        iterator.remove();
                        SelectableChannel selectableChannel = selectionKey.channel();
                        if (selectableChannel == datagramChannel) {
                            ((ByteBuffer)object).clear();
                            socketAddress = datagramChannel.receive((ByteBuffer)object);
                            inetAddress2 = ((InetSocketAddress)socketAddress).getAddress();
                            ((ByteBuffer)object).flip();
                            eSAChunk = null;
                            try {
                                eSAChunk = ESAFactory.readDatagram((ByteBuffer)object);
                            }
                            catch (ESAException eSAException) {
                                System.out.println(eSAException.getMessage());
                                continue;
                            }
                            if (eSAChunk == null || !(eSAChunk instanceof ESAIdentRspChunk)) continue;
                            eSAIdentRspChunk = (ESAIdentRspChunk)eSAChunk;
                            eSAUnitID = ESATracker.createUnitID(inetAddress2, eSAIdentRspChunk);
                            boolean bl = inetAddress2.equals(inetSocketAddress.getAddress());
                            ESAIdent eSAIdent2 = new ESAIdent();
                            eSAIdent2.unitID = eSAUnitID;
                            eSAIdent2.remoteAddress = inetAddress2;
                            eSAIdent2.localAddress = object4;
                            eSAIdent2.reachable = bl;
                            eSAIdent2.firmwareMode = eSAIdentRspChunk.getFirmwareMode();
                            eSAIdent2.protocolVersion = eSAIdentRspChunk.getProtocolVersion();
                            eSAIdent2.adminDialogID = eSAIdentRspChunk.getAdminDialogID();
                            eSAIdent2.adminParam = eSAIdentRspChunk.getAdminParam();
                            eSAIdent2.layoutDialogID = eSAIdentRspChunk.getLayoutDialogID();
                            eSAIdent2.layoutParam = eSAIdentRspChunk.getLayoutParam();
                            vector.add(eSAIdent2);
                            if (bl) {
                                ESATracker.logIdent(eSAIdent2);
                                continue;
                            }
                            hashtable.put(eSAUnitID, eSAIdent2);
                            ((ByteBuffer)object2).rewind();
                            if (((DatagramChannel)abstractInterruptibleChannel).send((ByteBuffer)object2, socketAddress) > 0) continue;
                            System.out.println("Error(check, " + eSAUnitID.toString() + "): Insufficient send buffer");
                            continue;
                        }
                        if (selectableChannel != abstractInterruptibleChannel) break block35;
                        ((ByteBuffer)object).clear();
                        socketAddress = ((DatagramChannel)abstractInterruptibleChannel).receive((ByteBuffer)object);
                        inetAddress2 = ((InetSocketAddress)socketAddress).getAddress();
                        ((ByteBuffer)object).flip();
                        eSAChunk = null;
                        try {
                            eSAChunk = ESAFactory.readDatagram((ByteBuffer)object);
                        }
                        catch (ESAException eSAException) {
                            System.out.println(eSAException.getMessage());
                            continue;
                        }
                        if (eSAChunk == null || !(eSAChunk instanceof ESAIdentRspChunk) || (eSAIdent = (ESAIdent)hashtable.get(eSAUnitID = ESATracker.createUnitID(inetAddress2, eSAIdentRspChunk = (ESAIdentRspChunk)eSAChunk))) == null) continue;
                        eSAIdent.reachable = true;
                        hashtable.remove(eSAUnitID);
                        ESATracker.logIdent(eSAIdent);
                    }
                    break;
                }
                throw new IOException("Select returned invalid channel / selection key");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (ESAException eSAException) {
                eSAException.printStackTrace();
            }
            finally {
                if (selector != null && selector.isOpen()) {
                    try {
                        selector.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if (datagramChannel != null && datagramChannel.isOpen()) {
                    try {
                        datagramChannel.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if (abstractInterruptibleChannel != null && abstractInterruptibleChannel.isOpen()) {
                    try {
                        abstractInterruptibleChannel.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    ESATracker.logIdent((ESAIdent)enumeration.nextElement());
                }
            }
        }
    }

    public static ESAIdent[] enumHosts() {
        System.out.println("----- Network scan -----");
        ScanEntry[] scanEntryArray = ESATracker.getScanList();
        if (scanEntryArray == null) {
            return new ESAIdent[0];
        }
        Vector<ESAIdent> vector = new Vector<ESAIdent>();
        for (int i = 0; i < scanEntryArray.length; ++i) {
            ESATracker.enumHosts(vector, scanEntryArray[i], null);
        }
        return vector.toArray(new ESAIdent[vector.size()]);
    }

    public static ESAIdent[] enumHosts(String string) {
        System.out.println("----- Single address scan -----");
        Vector<ESAIdent> vector = new Vector<ESAIdent>();
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            ESATracker.enumHosts(vector, null, inetAddress);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        return vector.toArray(new ESAIdent[vector.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ESAIdent retrieveIdent(InetAddress inetAddress) {
        try (DatagramSocket datagramSocket = null;){
            ByteBuffer byteBuffer = ByteBuffer.allocate(1500);
            datagramSocket = new DatagramSocket(62018);
            ESAChunk eSAChunk = new ESAChunk(257);
            ESAFactory.writeDatagram(byteBuffer, eSAChunk);
            DatagramPacket datagramPacket = new DatagramPacket(byteBuffer.array(), byteBuffer.limit());
            datagramPacket.setAddress(inetAddress);
            datagramPacket.setPort(62018);
            try {
                datagramSocket.send(datagramPacket);
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
            DatagramPacket datagramPacket2 = new DatagramPacket(byteBuffer.array(), byteBuffer.capacity());
            datagramSocket.setSoTimeout(100);
            while (true) {
                Object object;
                datagramPacket2.setLength(byteBuffer.capacity());
                try {
                    datagramSocket.receive(datagramPacket2);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    break;
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                    break;
                }
                byteBuffer.limit(datagramPacket2.getLength());
                byteBuffer.rewind();
                ESAChunk eSAChunk2 = null;
                try {
                    eSAChunk2 = ESAFactory.readDatagram(byteBuffer);
                }
                catch (ESAException eSAException) {
                    System.out.println(eSAException.getMessage());
                    continue;
                }
                if (eSAChunk2 == null || !(eSAChunk2 instanceof ESAIdentRspChunk)) continue;
                ESAIdentRspChunk eSAIdentRspChunk = (ESAIdentRspChunk)eSAChunk2;
                byte[] byArray = eSAIdentRspChunk.getUnitID();
                if (byArray == null || byArray.length == 0) {
                    object = datagramPacket2.getAddress().getAddress();
                    byArray = new byte[1 + ((byte[])object).length];
                    byArray[0] = 4;
                    System.arraycopy(object, 0, byArray, 1, ((byte[])object).length);
                }
                ESAUnitID eSAUnitID = new ESAUnitID(byArray);
                object = new ESAIdent();
                object.unitID = eSAUnitID;
                object.remoteAddress = datagramPacket2.getAddress();
                object.localAddress = null;
                object.reachable = true;
                object.firmwareMode = eSAIdentRspChunk.getFirmwareMode();
                object.protocolVersion = eSAIdentRspChunk.getProtocolVersion();
                object.adminDialogID = eSAIdentRspChunk.getAdminDialogID();
                object.adminParam = eSAIdentRspChunk.getAdminParam();
                object.layoutDialogID = eSAIdentRspChunk.getLayoutDialogID();
                object.layoutParam = eSAIdentRspChunk.getLayoutParam();
                Object object2 = object;
                return object2;
            }
        }
        return null;
    }

    public static class ScanEntry {
        public NetworkInterface networkInterface;
        public InterfaceAddress interfaceAddress;

        public ScanEntry(NetworkInterface networkInterface, InterfaceAddress interfaceAddress) {
            this.networkInterface = networkInterface;
            this.interfaceAddress = interfaceAddress;
        }
    }
}

