/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.esa.chunks;

import dexlogic.io.esa.ESAException;
import dexlogic.io.esa.chunks.IPLChunk;
import java.nio.ByteBuffer;

public class IPLAddressChunk
extends IPLChunk {
    protected int byteCount;
    protected int flags;
    protected int selector;
    protected int startAddress;

    IPLAddressChunk(int n) {
        super(n);
    }

    IPLAddressChunk(int n, ByteBuffer byteBuffer) throws ESAException {
        super(n, byteBuffer);
    }

    @Override
    protected void writeBytes(ByteBuffer byteBuffer) throws ESAException {
        super.writeBytes(byteBuffer);
        byteBuffer.putShort((short)this.byteCount);
        byteBuffer.put((byte)this.flags);
        byteBuffer.put((byte)this.selector);
        byteBuffer.putInt(this.startAddress);
    }

    @Override
    protected void readBytes(ByteBuffer byteBuffer) throws ESAException {
        super.readBytes(byteBuffer);
        if (byteBuffer.remaining() < 8) {
            throw new ESAException(-1, "Message size");
        }
        this.byteCount = byteBuffer.getShort() & 0xFFFF;
        this.flags = byteBuffer.get() & 0xFF;
        this.selector = byteBuffer.get() & 0xFF;
        this.startAddress = byteBuffer.getInt();
    }

    public void setSelector(int n) {
        this.selector = n;
    }

    public int getSelector() {
        return this.selector;
    }

    public void setStartAddress(int n) {
        this.startAddress = n;
    }

    public int getStartAddress() {
        return this.startAddress;
    }
}

