/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.esa.chunks;

import dexlogic.io.esa.ESAException;
import dexlogic.io.esa.chunks.IPLRegionChunk;
import java.nio.ByteBuffer;

public class IPLDumpRspChunk
extends IPLRegionChunk {
    protected byte[] dumpBytes;

    @Override
    protected void readBytes(ByteBuffer byteBuffer) throws ESAException {
        super.readBytes(byteBuffer);
        int n = byteBuffer.remaining();
        if (n != this.byteCount) {
            throw new ESAException(-1, "Dump byte count mismatch");
        }
        this.dumpBytes = new byte[n];
        System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), this.dumpBytes, 0, n);
    }

    public IPLDumpRspChunk(ByteBuffer byteBuffer) throws ESAException {
        super(4352, byteBuffer);
    }

    public byte[] getDumpBytes() {
        return this.dumpBytes;
    }
}

