/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.esa.chunks;

import dexlogic.io.esa.ESAException;
import dexlogic.io.esa.chunks.IPLAddressChunk;
import java.nio.ByteBuffer;

public class IPLVerifyDataReqChunk
extends IPLAddressChunk {
    protected int imageLength;
    protected int imageCRC;

    @Override
    protected void writeBytes(ByteBuffer byteBuffer) throws ESAException {
        super.writeBytes(byteBuffer);
        byteBuffer.putInt(this.imageLength);
        byteBuffer.putInt(this.imageCRC);
    }

    @Override
    protected void readBytes(ByteBuffer byteBuffer) throws ESAException {
        super.readBytes(byteBuffer);
        if (byteBuffer.remaining() < 8) {
            throw new ESAException(-1, "Message size");
        }
        this.imageLength = byteBuffer.getInt();
        this.imageCRC = byteBuffer.getInt();
    }

    public IPLVerifyDataReqChunk() {
        super(4641);
    }

    public void setImageLength(int n) {
        this.imageLength = n;
    }

    public int getImageLength() {
        return this.imageLength;
    }

    public void setImageCRC(int n) {
        this.imageCRC = n;
    }

    public int getImageCRC() {
        return this.imageCRC;
    }
}

