/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.netview;

import dexlogic.NetView;
import dexlogic.devlog.DeviceLogFileFilter;
import dexlogic.devlog.WDeviceLogFrame;
import dexlogic.io.esa.ESAHost;
import dexlogic.io.esa.ESANetwork;
import dexlogic.io.esa.ESARoute;
import dexlogic.netview.NetViewDeviceNode;
import dexlogic.netview.NetViewTreeNode;
import dexlogic.netview.WNetViewFrame;
import dexlogic.netview.admin.A04NetViewDeviceNode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultTreeModel;

class NetViewRootNode
extends NetViewTreeNode {
    private void collectHosts(ESANetwork eSANetwork, Hashtable<ESAHost, NetViewDeviceNode> hashtable, NetViewTreeNode netViewTreeNode) {
        Hashtable hashtable2 = new Hashtable();
        if (netViewTreeNode instanceof NetViewDeviceNode) {
            NetViewDeviceNode netViewDeviceNode = (NetViewDeviceNode)netViewTreeNode;
            ESAHost eSAHost = netViewDeviceNode.getHost();
            eSANetwork.addHost(eSAHost);
            hashtable.put(eSAHost, netViewDeviceNode);
        }
        for (int i = 0; i < netViewTreeNode.getChildCount(); ++i) {
            this.collectHosts(eSANetwork, hashtable, (NetViewTreeNode)netViewTreeNode.getChildAt(i));
        }
    }

    private void updateTree(DefaultTreeModel defaultTreeModel, Hashtable<ESAHost, NetViewDeviceNode> hashtable, ESAHost[] eSAHostArray) {
        NetViewTreeNode netViewTreeNode = (NetViewTreeNode)defaultTreeModel.getRoot();
        for (int i = 0; i < eSAHostArray.length; ++i) {
            ESAHost eSAHost = eSAHostArray[i];
            NetViewDeviceNode netViewDeviceNode = hashtable.get(eSAHost);
            if (netViewDeviceNode == null) {
                netViewDeviceNode = eSAHost.getAdminDialogID() == 4 ? new A04NetViewDeviceNode(eSAHost) : new NetViewDeviceNode(eSAHost);
                int n = netViewTreeNode.getChildCount();
                defaultTreeModel.insertNodeInto(netViewDeviceNode, netViewTreeNode, n);
                if (n != 0) continue;
                defaultTreeModel.reload();
                continue;
            }
            ESARoute[] eSARouteArray = eSAHost.getRoutes();
            if (eSARouteArray == null || eSARouteArray.length == 0) {
                defaultTreeModel.removeNodeFromParent(netViewDeviceNode);
                continue;
            }
            netViewDeviceNode.hostChanged();
            defaultTreeModel.nodeChanged(netViewDeviceNode);
        }
    }

    private void processScan(DefaultTreeModel defaultTreeModel) {
        ESANetwork eSANetwork = new ESANetwork();
        Hashtable<ESAHost, NetViewDeviceNode> hashtable = new Hashtable<ESAHost, NetViewDeviceNode>();
        this.collectHosts(eSANetwork, hashtable, (NetViewTreeNode)defaultTreeModel.getRoot());
        ESAHost[] eSAHostArray = eSANetwork.scanNetwork();
        ESAHost[] eSAHostArray2 = eSANetwork.removeHosts(eSAHostArray);
        if (eSAHostArray != null) {
            this.updateTree(defaultTreeModel, hashtable, eSAHostArray);
        }
        if (eSAHostArray2 != null) {
            for (int i = 0; i < eSAHostArray2.length; ++i) {
                ESAHost eSAHost = eSAHostArray2[i];
                NetViewDeviceNode netViewDeviceNode = hashtable.get(eSAHost);
                netViewDeviceNode.updateDisplay();
                defaultTreeModel.nodeChanged(netViewDeviceNode);
            }
        }
    }

    private void processAdd(JTree jTree, DefaultTreeModel defaultTreeModel) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        JTextField jTextField = new JTextField();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)new JLabel("Address or network to look for a device"), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jTextField, gridBagConstraints);
        int n = -1;
        int n2 = 2;
        JOptionPane jOptionPane = new JOptionPane(jPanel, n, n2);
        JDialog jDialog = jOptionPane.createDialog(jTree, "Add device");
        jDialog.setVisible(true);
        jDialog.dispose();
        Object object = jOptionPane.getValue();
        if (object != null && object instanceof Integer && (Integer)object != 0) {
            return;
        }
        ESANetwork eSANetwork = new ESANetwork();
        Hashtable<ESAHost, NetViewDeviceNode> hashtable = new Hashtable<ESAHost, NetViewDeviceNode>();
        this.collectHosts(eSANetwork, hashtable, (NetViewTreeNode)defaultTreeModel.getRoot());
        ESAHost[] eSAHostArray = eSANetwork.scanAddress(jTextField.getText());
        if (eSAHostArray == null) {
            String string = "No new device";
            String string2 = "No new device was found at the given address";
            JOptionPane.showMessageDialog(jTree, string2, string, 0);
            return;
        }
        this.updateTree(defaultTreeModel, hashtable, eSAHostArray);
    }

    private void addExpertMenu(JTree jTree, JPopupMenu jPopupMenu) {
        jPopupMenu.add(new JPopupMenu.Separator());
        JMenuItem jMenuItem = jPopupMenu.add(new JMenuItem("Open Log..."));
        jMenuItem.addActionListener(new AbstractAction(){
            JTree invoker;

            public AbstractAction init(JTree jTree) {
                this.invoker = jTree;
                return this;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(".");
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.addChoosableFileFilter(new DeviceLogFileFilter());
                try {
                    int n = jFileChooser.showOpenDialog(this.invoker);
                    if (n == 0) {
                        File file = jFileChooser.getSelectedFile();
                        WDeviceLogFrame wDeviceLogFrame = new WDeviceLogFrame(file);
                        wDeviceLogFrame.pack();
                        wDeviceLogFrame.setVisible(true);
                    }
                }
                catch (IOException iOException) {
                    WNetViewFrame.showIOError(this.invoker, iOException);
                }
            }
        }.init(jTree));
    }

    public NetViewRootNode() {
        this.setUserObject("Network");
    }

    @Override
    public void showPopup(JTree jTree, int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = jPopupMenu.add(new JMenuItem("Scan"));
        jMenuItem.addActionListener(new AbstractAction(){
            DefaultTreeModel treeModel;

            public AbstractAction init(DefaultTreeModel defaultTreeModel) {
                this.treeModel = defaultTreeModel;
                return this;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NetViewRootNode.this.processScan(this.treeModel);
            }
        }.init((DefaultTreeModel)jTree.getModel()));
        jMenuItem = jPopupMenu.add(new JMenuItem("Add..."));
        jMenuItem.addActionListener(new AbstractAction(){
            JTree invoker;
            DefaultTreeModel treeModel;

            public AbstractAction init(JTree jTree, DefaultTreeModel defaultTreeModel) {
                this.invoker = jTree;
                this.treeModel = defaultTreeModel;
                return this;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NetViewRootNode.this.processAdd(this.invoker, this.treeModel);
            }
        }.init(jTree, (DefaultTreeModel)jTree.getModel()));
        if (NetView.expertMode) {
            this.addExpertMenu(jTree, jPopupMenu);
        }
        jPopupMenu.show(jTree, n, n2);
    }
}

