/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.netview;

import dexlogic.netview.NetViewTreeNode;
import dexlogic.netview.TreeNodeSelection;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class TreeDropTargetHandler
implements DropTargetListener {
    private TreePath getMovePath(DropTargetEvent dropTargetEvent, TreeNode treeNode, Transferable transferable) {
        Object object;
        DataFlavor dataFlavor = TreeNodeSelection.TREE_PATH_FLAVOR;
        if (!transferable.isDataFlavorSupported(dataFlavor)) {
            return null;
        }
        try {
            object = transferable.getTransferData(dataFlavor);
        }
        catch (Exception exception) {
            return null;
        }
        TreeNodeSelection.IndexPath indexPath = (TreeNodeSelection.IndexPath)object;
        TreePath treePath = indexPath.getTreePath(treeNode);
        return treePath;
    }

    private TreePath getParentPath(JTree jTree, DropTargetEvent dropTargetEvent, Point point, TreePath treePath) {
        TreePath treePath2 = jTree.getPathForLocation(point.x, point.y);
        if (treePath2 == null || treePath == null) {
            return null;
        }
        NetViewTreeNode netViewTreeNode = (NetViewTreeNode)treePath2.getLastPathComponent();
        NetViewTreeNode netViewTreeNode2 = (NetViewTreeNode)treePath.getLastPathComponent();
        if (netViewTreeNode == null || netViewTreeNode2 == null) {
            return null;
        }
        for (TreePath treePath3 = treePath2; treePath3 != null; treePath3 = treePath3.getParentPath()) {
            if (treePath3.getLastPathComponent() != netViewTreeNode2) continue;
            return null;
        }
        return treePath2;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.dragOver(dropTargetDragEvent);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
        JTree jTree = (JTree)dropTargetContext.getComponent();
        TreeModel treeModel = jTree.getModel();
        TreeNode treeNode = (TreeNode)treeModel.getRoot();
        TreePath treePath = this.getMovePath(dropTargetDragEvent, treeNode, dropTargetDragEvent.getTransferable());
        TreePath treePath2 = this.getParentPath(jTree, dropTargetDragEvent, dropTargetDragEvent.getLocation(), treePath);
        if (treePath == null || treePath2 == null) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        dropTargetDragEvent.acceptDrag(2);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
        JTree jTree = (JTree)dropTargetContext.getComponent();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        TreeNode treeNode = (TreeNode)defaultTreeModel.getRoot();
        TreePath treePath = this.getMovePath(dropTargetDropEvent, treeNode, dropTargetDropEvent.getTransferable());
        TreePath treePath2 = this.getParentPath(jTree, dropTargetDropEvent, dropTargetDropEvent.getLocation(), treePath);
        if (treePath == null || treePath2 == null) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
        NetViewTreeNode netViewTreeNode = (NetViewTreeNode)treePath2.getLastPathComponent();
        NetViewTreeNode netViewTreeNode2 = (NetViewTreeNode)treePath.getLastPathComponent();
        defaultTreeModel.removeNodeFromParent(netViewTreeNode2);
        int n = netViewTreeNode.getChildCount();
        defaultTreeModel.insertNodeInto(netViewTreeNode2, netViewTreeNode, n);
        if (n == 0) {
            defaultTreeModel.reload(netViewTreeNode);
        }
        dropTargetDropEvent.dropComplete(true);
    }
}

