/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.netview;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class TreeNodeSelection
implements Serializable,
Transferable {
    private DataFlavor[] flavors = new DataFlavor[]{TREE_PATH_FLAVOR};
    private IndexPath indexPath;
    public static DataFlavor TREE_PATH_FLAVOR = new DataFlavor(TreePath.class, "Tree Path");

    public TreeNodeSelection(TreePath treePath) {
        this.indexPath = new IndexPath(treePath);
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        int n = this.flavors.length;
        for (int i = 0; i < n; ++i) {
            if (!dataFlavor.equals(this.flavors[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(dataFlavor)) {
            return this.indexPath;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public class IndexPath
    implements Serializable {
        int[] pathHashCodes;
        int[] pathIndices;
        int nodeHashCode;

        public IndexPath(TreePath treePath) {
            TreePath treePath2;
            int n = treePath.getPathCount() - 1;
            this.pathIndices = new int[n];
            this.pathHashCodes = new int[n];
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            this.nodeHashCode = treeNode.hashCode();
            while ((treePath2 = treePath.getParentPath()) != null) {
                TreeNode treeNode2 = (TreeNode)treePath2.getLastPathComponent();
                this.pathHashCodes[--n] = treeNode2.hashCode();
                this.pathIndices[n] = treeNode2.getIndex(treeNode);
                treePath = treePath2;
                treeNode = treeNode2;
            }
        }

        public TreePath getTreePath(TreeNode treeNode) {
            Object[] objectArray = new TreeNode[this.pathIndices.length + 1];
            for (int i = 0; i < this.pathIndices.length; ++i) {
                if (this.pathHashCodes[i] != treeNode.hashCode()) {
                    throw new Error("Hash code mismatch");
                }
                objectArray[i] = treeNode;
                treeNode = treeNode.getChildAt(this.pathIndices[i]);
            }
            if (this.nodeHashCode != treeNode.hashCode()) {
                throw new Error("Hash code mismatch");
            }
            objectArray[this.pathIndices.length] = treeNode;
            return new TreePath(objectArray);
        }
    }
}

