/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.netview;

import dexlogic.netview.NetViewRootNode;
import dexlogic.netview.NetViewTreeNode;
import dexlogic.netview.TreeDropTargetHandler;
import dexlogic.netview.TreeNodeSelection;
import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class WNetViewTree
extends JTree
implements DragGestureListener {
    public WNetViewTree() {
        NetViewRootNode netViewRootNode = new NetViewRootNode();
        ((DefaultTreeModel)this.getModel()).setRoot(netViewRootNode);
        URL uRL = this.getClass().getResource("/network.png");
        if (uRL != null) {
            netViewRootNode.setIcon(new ImageIcon(uRL));
        }
        this.addMouseListener(new MouseAdapter(){

            private void checkForPopup(MouseEvent mouseEvent) {
                if (!(mouseEvent.getComponent() instanceof JTree)) {
                    return;
                }
                JTree jTree = (JTree)mouseEvent.getComponent();
                if (mouseEvent.isPopupTrigger()) {
                    TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath == null) {
                        return;
                    }
                    Object object = treePath.getLastPathComponent();
                    if (!(object instanceof NetViewTreeNode)) {
                        return;
                    }
                    NetViewTreeNode netViewTreeNode = (NetViewTreeNode)object;
                    netViewTreeNode.showPopup(jTree, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.checkForPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.checkForPopup(mouseEvent);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                this.checkForPopup(mouseEvent);
            }
        });
        DragSource dragSource = DragSource.getDefaultDragSource();
        int n = 2;
        dragSource.createDefaultDragGestureRecognizer(this, n, this);
        new DropTarget(this, new TreeDropTargetHandler());
        this.setRowHeight(0);
        URL uRL2 = this.getClass().getResource("/unit.png");
        ImageIcon imageIcon = uRL2 != null ? new ImageIcon(uRL2) : (ImageIcon)null;
        this.setCellRenderer(new DefaultTreeCellRenderer(){
            private Border border = BorderFactory.createEmptyBorder(4, 0, 4, 0);
            ImageIcon defaultIcon;

            public DefaultTreeCellRenderer setDefaultIcon(ImageIcon imageIcon) {
                this.defaultIcon = imageIcon;
                return this;
            }

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                NetViewTreeNode netViewTreeNode = (NetViewTreeNode)object;
                jLabel.setBorder(this.border);
                ImageIcon imageIcon = netViewTreeNode.getIcon();
                if (imageIcon != null) {
                    jLabel.setIcon(imageIcon);
                } else if (this.defaultIcon != null) {
                    jLabel.setIcon(this.defaultIcon);
                }
                return jLabel;
            }
        }.setDefaultIcon(imageIcon));
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        JTree jTree = (JTree)dragGestureEvent.getComponent();
        Point point = dragGestureEvent.getDragOrigin();
        TreePath treePath = jTree.getPathForLocation(point.x, point.y);
        if (treePath == null || treePath.getPathCount() <= 1) {
            return;
        }
        TreeNodeSelection treeNodeSelection = new TreeNodeSelection(treePath);
        dragGestureEvent.startDrag(null, treeNodeSelection, null);
    }
}

