/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.netview;

import dexlogic.io.esa.ESAFile;
import dexlogic.io.esa.ESAHost;
import dexlogic.io.esa.ESALoadListener;
import dexlogic.io.esa.ESARoute;
import dexlogic.io.esa.ESATarget;
import dexlogic.netview.WNetViewFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;

public class WUpdateDialog
extends JDialog
implements ESALoadListener {
    private ESAHost esaHost;
    private ESAFile esaFile;
    private JTextArea logTextArea;
    private JProgressBar progressBar;
    private JButton startButton;
    private JButton doneButton;

    private void runUpdate() {
        this.startButton.setEnabled(false);
        this.doneButton.setEnabled(false);
        this.setDefaultCloseOperation(0);
        SwingWorker swingWorker = new SwingWorker(){
            private ESAHost esaHost;
            private File file;

            protected Object doInBackground() {
                WUpdateDialog.this.progressBar.setIndeterminate(true);
                ESATarget eSATarget = null;
                try {
                    eSATarget = new ESATarget();
                    ESARoute eSARoute = this.esaHost.getDefaultRoute();
                    eSATarget.openConnection(eSARoute.getRemoteAddress(), eSARoute.getLocalAddress());
                    if (!eSATarget.identMatch(this.esaHost.getUnitID().getIDBytes())) {
                        throw new IOException("Target unit mismatch");
                    }
                    eSATarget.update(WUpdateDialog.this.esaFile, WUpdateDialog.this);
                }
                catch (IOException iOException) {
                    WNetViewFrame.showIOError(WUpdateDialog.this, iOException);
                }
                finally {
                    if (eSATarget != null && eSATarget.isConnectionOpen()) {
                        try {
                            eSATarget.closeConnection();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
                WUpdateDialog.this.startButton.setEnabled(true);
                WUpdateDialog.this.doneButton.setEnabled(true);
                WUpdateDialog.this.setDefaultCloseOperation(1);
                WUpdateDialog.this.progressBar.setIndeterminate(false);
                return null;
            }

            public SwingWorker init(ESAHost eSAHost, File file) {
                this.esaHost = eSAHost;
                this.file = file;
                return this;
            }
        }.init(this.esaHost, this.esaFile);
        swingWorker.execute();
    }

    private JComponent buildDisplayUI() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(12, 0, 12, 0));
        this.logTextArea = new JTextArea();
        this.logTextArea.setColumns(80);
        this.logTextArea.setRows(8);
        this.logTextArea.setFont(new Font("Monospaced", 0, 12));
        this.logTextArea.setEditable(false);
        this.progressBar = new JProgressBar();
        JScrollPane jScrollPane = new JScrollPane(this.logTextArea);
        jScrollPane.setVerticalScrollBarPolicy(22);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        jPanel.add((Component)this.progressBar, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    private JComponent buildControlUI() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.startButton = new JButton("Start");
        this.startButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WUpdateDialog.this.runUpdate();
            }
        });
        this.doneButton = new JButton("Done");
        this.doneButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WUpdateDialog.this.setVisible(false);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.startButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        jPanel.add((Component)this.doneButton, gridBagConstraints);
        return jPanel;
    }

    private JComponent buildUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        jPanel.add((Component)this.buildDisplayUI(), "Center");
        jPanel.add((Component)this.buildControlUI(), "South");
        return jPanel;
    }

    public WUpdateDialog(Window window, ESAHost eSAHost, ESAFile eSAFile) {
        super(window);
        this.esaHost = eSAHost;
        this.esaFile = eSAFile;
        this.setContentPane(this.buildUI());
    }

    public void setInfoPane(JComponent jComponent) {
        ((JPanel)this.getContentPane()).add((Component)jComponent, "North");
    }

    @Override
    public void loadLog(String string) {
        this.logTextArea.append(string);
        this.logTextArea.append("\n");
    }

    @Override
    public void loadCopyStarted(int n, int n2) {
        this.progressBar.setMinimum(n);
        this.progressBar.setMaximum(n2);
        this.progressBar.setValue(n);
        this.progressBar.setIndeterminate(false);
    }

    @Override
    public void loadCopyProgress(int n) {
        this.progressBar.setValue(n);
    }

    @Override
    public void loadCopyEnded() {
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(0);
        this.progressBar.setValue(0);
        this.progressBar.setIndeterminate(true);
    }
}

