/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.netview.layout;

import dexlogic.io.esa.ESAFile;
import dexlogic.io.esa.ESAFileDump;
import dexlogic.io.esa.ESAHost;
import dexlogic.io.esa.ESARoute;
import dexlogic.io.esa.ESATarget;
import dexlogic.netview.WNetViewFrame;
import dexlogic.netview.layout.L05WUpdateLicenseDialog;
import dexlogic.netview.layout.L05WUpdatePlatformDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class L05WFirmwareDialog
extends JDialog {
    private ESAHost esaHost;
    private String targetUnitID = null;
    private JLabel targetPlatformIDLabel = null;
    private JLabel targetPlatformFilenameLabel = null;
    private JLabel targetPlatformVersionLabel = null;
    private JLabel targetPlatformLibraryLabel = null;
    private JLabel targetLicenseFilenameLabel = null;
    private JLabel targetDNALabel = null;
    private JLabel targetMonitorVersionLabel = null;
    JButton retrievePlatformButton = null;
    JButton retrieveLicenseButton = null;

    private void updatePlatformPressed() {
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(new PlatformFileFilter("Platform archives", ".zip"));
        int n = jFileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        try {
            ESAFile eSAFile = new ESAFile(jFileChooser.getSelectedFile().getPath(), 1, 0x100000, false);
            ZipFile zipFile = new ZipFile(eSAFile);
            ZipEntry zipEntry = zipFile.getEntry("manifest.txt");
            if (zipEntry == null) {
                throw new IOException("Archive has no 'manifest.txt' entry");
            }
            Properties properties = new Properties();
            properties.load(zipFile.getInputStream(zipEntry));
            String string = this.targetPlatformIDLabel.getText();
            String string2 = (String)properties.get("PlatformID");
            if (string2 == null) {
                throw new IOException("Manifest has no 'PlatformID' key");
            }
            if (!string2.equals(string)) {
                throw new IOException("PlatformID mismatch. Archive is " + string2);
            }
            String string3 = (String)properties.get("Version");
            if (string3 == null) {
                throw new IOException("Manifest has no 'Version' key");
            }
            L05WUpdatePlatformDialog l05WUpdatePlatformDialog = new L05WUpdatePlatformDialog((Window)this, this.esaHost, eSAFile);
            l05WUpdatePlatformDialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    L05WFirmwareDialog.this.updateLabels();
                }
            });
            String string4 = this.targetPlatformFilenameLabel.getText();
            String string5 = this.targetPlatformVersionLabel.getText();
            l05WUpdatePlatformDialog.setFromPlatform(string4, string5);
            l05WUpdatePlatformDialog.setToPlatform(eSAFile.getName(), string3);
            l05WUpdatePlatformDialog.pack();
            l05WUpdatePlatformDialog.setResizable(false);
            l05WUpdatePlatformDialog.setVisible(true);
        }
        catch (IOException iOException) {
            WNetViewFrame.showIOError(this, iOException);
        }
    }

    private void updateLicensePressed() {
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(new PlatformFileFilter("License files", ".lic"));
        int n = jFileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        try {
            File file = jFileChooser.getSelectedFile();
            long l = file.length();
            if (l <= 0L || l >= 16128L) {
                throw new IOException("Invalid file length " + l);
            }
            ESAFile eSAFile = new ESAFile(file.getPath(), 1, 1032192, false);
            L05WUpdateLicenseDialog l05WUpdateLicenseDialog = new L05WUpdateLicenseDialog((Window)this, this.esaHost, eSAFile);
            l05WUpdateLicenseDialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    L05WFirmwareDialog.this.updateLabels();
                }
            });
            String string = this.targetLicenseFilenameLabel.getText();
            l05WUpdateLicenseDialog.setFromLicense(string);
            l05WUpdateLicenseDialog.setToLicense(eSAFile.getName());
            l05WUpdateLicenseDialog.pack();
            l05WUpdateLicenseDialog.setResizable(false);
            l05WUpdateLicenseDialog.setVisible(true);
        }
        catch (IOException iOException) {
            WNetViewFrame.showIOError(this, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveFilePressed(int n, int n2) {
        ESATarget eSATarget = null;
        try {
            eSATarget = new ESATarget();
            ESARoute eSARoute = this.esaHost.getDefaultRoute();
            eSATarget.openConnection(eSARoute.getRemoteAddress(), eSARoute.getLocalAddress());
            if (!eSATarget.identMatch(this.esaHost.getUnitID().getIDBytes())) {
                throw new IOException("Target unit mismatch");
            }
            ESAFileDump eSAFileDump = eSATarget.dumpFile(n, n2);
            if (eSAFileDump == null) {
                throw new IOException("Target dump failed");
            }
            JFileChooser jFileChooser = new JFileChooser(".");
            jFileChooser.setSelectedFile(new File(eSAFileDump.getFilename()));
            int n3 = jFileChooser.showSaveDialog(this);
            if (n3 != 0) {
                return;
            }
            byte[] byArray = eSAFileDump.getDataBytes();
            File file = jFileChooser.getSelectedFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray, 0, byArray.length);
            fileOutputStream.close();
            file.setLastModified(eSAFileDump.getLastModified());
        }
        catch (IOException iOException) {
            WNetViewFrame.showIOError(this, iOException);
        }
        finally {
            if (eSATarget != null && eSATarget.isConnectionOpen()) {
                try {
                    eSATarget.closeConnection();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveLabels() throws IOException {
        this.targetPlatformIDLabel.setText(null);
        this.targetPlatformFilenameLabel.setText(null);
        this.targetPlatformVersionLabel.setText(null);
        this.targetPlatformLibraryLabel.setText(null);
        this.targetLicenseFilenameLabel.setText(null);
        this.targetDNALabel.setText(null);
        this.targetMonitorVersionLabel.setText(null);
        this.retrievePlatformButton.setEnabled(false);
        this.retrieveLicenseButton.setEnabled(false);
        ESATarget eSATarget = null;
        try {
            String string;
            eSATarget = new ESATarget();
            ESARoute eSARoute = this.esaHost.getDefaultRoute();
            eSATarget.openConnection(eSARoute.getRemoteAddress(), eSARoute.getLocalAddress());
            if (!eSATarget.identMatch(this.esaHost.getUnitID().getIDBytes())) {
                throw new IOException("Target unit mismatch");
            }
            Hashtable hashtable = null;
            hashtable = eSATarget.retrieveProperties();
            if (hashtable == null) {
                throw new IOException("Target properies retrieval failed");
            }
            this.targetPlatformIDLabel.setText((String)hashtable.get("pltIdent"));
            this.targetPlatformFilenameLabel.setText((String)hashtable.get("pltFilename"));
            this.targetPlatformVersionLabel.setText((String)hashtable.get("pltVersion"));
            this.targetPlatformLibraryLabel.setText((String)hashtable.get("pltLibrary"));
            this.targetLicenseFilenameLabel.setText((String)hashtable.get("licFilename"));
            this.targetDNALabel.setText((String)hashtable.get("licDNA"));
            this.targetMonitorVersionLabel.setText((String)hashtable.get("monVersion"));
            String string2 = this.targetPlatformFilenameLabel.getText();
            if (string2 != null) {
                boolean bl = true;
                if (string2.length() == 0) {
                    bl = false;
                }
                if (string2.equalsIgnoreCase("N/A")) {
                    bl = false;
                }
                this.retrievePlatformButton.setEnabled(bl);
            }
            if ((string = this.targetLicenseFilenameLabel.getText()) != null) {
                boolean bl = true;
                if (string.length() == 0) {
                    bl = false;
                }
                if (string.equalsIgnoreCase("N/A")) {
                    bl = false;
                }
                this.retrieveLicenseButton.setEnabled(bl);
            }
        }
        finally {
            if (eSATarget != null && eSATarget.isConnectionOpen()) {
                try {
                    eSATarget.closeConnection();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.pack();
        }
    }

    private void updateLabels() {
        try {
            this.retrieveLabels();
        }
        catch (IOException iOException) {
            WNetViewFrame.showIOError(this, iOException);
        }
    }

    private JComponent buildUI() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.targetPlatformIDLabel = new JLabel();
        this.targetPlatformFilenameLabel = new JLabel();
        this.targetPlatformVersionLabel = new JLabel();
        this.targetPlatformLibraryLabel = new JLabel();
        this.targetLicenseFilenameLabel = new JLabel();
        this.targetDNALabel = new JLabel();
        this.targetMonitorVersionLabel = new JLabel();
        JButton jButton = new JButton("Update...");
        jButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                L05WFirmwareDialog.this.updatePlatformPressed();
            }
        });
        this.retrievePlatformButton = new JButton("Retrieve");
        this.retrievePlatformButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                L05WFirmwareDialog.this.retrieveFilePressed(1, 0x100000);
            }
        });
        JButton jButton2 = new JButton("Update...");
        jButton2.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                L05WFirmwareDialog.this.updateLicensePressed();
            }
        });
        this.retrieveLicenseButton = new JButton("Retrieve");
        this.retrieveLicenseButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                L05WFirmwareDialog.this.retrieveFilePressed(1, 1032192);
            }
        });
        JButton jButton3 = new JButton("Update...");
        jButton3.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = -1;
        int n2 = 8;
        int n3 = 2;
        Insets insets = new Insets(n3, 0, n3, 0);
        Insets insets2 = new Insets(n3, n2, n3, 0);
        Insets insets3 = new Insets(8, 0, 8, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = ++n;
        gridBagConstraints.insets = insets;
        jPanel.add((Component)new JLabel("Target unitID"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = insets2;
        jPanel.add((Component)new JLabel(this.targetUnitID), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = insets;
        jPanel.add((Component)new JLabel("Target Address"), gridBagConstraints);
        ESARoute[] eSARouteArray = this.esaHost.getRoutes();
        for (int i = 0; i < eSARouteArray.length; ++i) {
            if (i != 0) {
                // empty if block
            }
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = ++n;
            gridBagConstraints.insets = insets2;
            jPanel.add((Component)new JLabel(eSARouteArray[i].getRemoteAddress().getHostAddress()), gridBagConstraints);
        }
        gridBagConstraints.gridx = 0;
        ++n;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = insets3;
        jPanel.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = insets;
        jPanel.add((Component)new JLabel("Target Platform"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = insets2;
        jPanel.add((Component)this.targetPlatformIDLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = insets;
        jPanel.add((Component)new JLabel("Platform Filename"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = insets2;
        jPanel.add((Component)this.targetPlatformFilenameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2 * n2, 0, 0);
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(0, n2, 0, 0);
        jPanel.add((Component)this.retrievePlatformButton, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = insets;
        jPanel.add((Component)new JLabel("Platform Version"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = insets2;
        jPanel.add((Component)this.targetPlatformVersionLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = insets;
        jPanel.add((Component)new JLabel("Library Version"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = insets2;
        jPanel.add((Component)this.targetPlatformLibraryLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = insets3;
        jPanel.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = insets;
        jPanel.add((Component)new JLabel("License Filename"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = insets2;
        jPanel.add((Component)this.targetLicenseFilenameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2 * n2, 0, 0);
        jPanel.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(0, n2, 0, 0);
        jPanel.add((Component)this.retrieveLicenseButton, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = insets;
        jPanel.add((Component)new JLabel("Target DNA"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = insets2;
        jPanel.add((Component)this.targetDNALabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = insets3;
        jPanel.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = insets;
        jPanel.add((Component)new JLabel("Monitor Version"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = insets2;
        jPanel.add((Component)this.targetMonitorVersionLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2 * n2, 0, 0);
        jPanel.add((Component)jButton3, gridBagConstraints);
        gridBagConstraints.fill = 1;
        return jPanel;
    }

    public L05WFirmwareDialog(Window window, ESAHost eSAHost) throws IOException {
        super(window);
        this.setTitle("Firmware Information");
        this.esaHost = eSAHost;
        this.targetUnitID = eSAHost.getUnitID().toString();
        this.setContentPane(this.buildUI());
        this.setResizable(false);
        this.retrieveLabels();
    }

    private static class PlatformFileFilter
    extends FileFilter {
        private String description;
        private String extension;

        public PlatformFileFilter(String string, String string2) {
            this.description = string;
            this.extension = string2;
        }

        @Override
        public boolean accept(File file) {
            if (file.isHidden()) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            if (file.isFile()) {
                String string = file.getName();
                return string.endsWith(this.extension);
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.description + " (*" + this.extension + ")";
        }
    }
}

